/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.interest;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentIntBillUnWriteOffService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(CurrentIntBillUnWriteOffService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("batchnoid");
        selector.add("bechargeinstamt");
        selector.add("thischargeinstamt");
        selector.add("afterchargeinstamt");
        selector.add("writeoffstatus");
        selector.add("writeoffdate");
        return selector;
    }

    public void process(DynamicObject[] interestBills) throws KDException {
        Set batchNoIds = Arrays.stream(interestBills).filter(v -> CurrentBizTypeEnum.isCurrentInt((String)v.getString("biztype"))).map(o -> o.getLong("batchnoid")).collect(Collectors.toSet());
        logger.info("unwriteoff batchNoIds:" + batchNoIds);
        for (Long batchNoId : batchNoIds) {
            this.executeUnWriteOff(batchNoId);
        }
    }

    private void executeUnWriteOff(Long batchNoId) {
        DynamicObject[] interestBills;
        QFilter filter = new QFilter("batchnoid", "=", (Object)batchNoId);
        for (DynamicObject interestBill : interestBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])filter.toArray())) {
            interestBill.set("bechargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("thischargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("afterchargeinstamt", (Object)BigDecimal.ZERO);
            interestBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
            interestBill.set("writeoffdate", null);
        }
        DynamicObject[] relations = TmcDataServiceHelper.load((String)"ifm_instwriteoff_relation", (String)"preinstbillid,amount", (QFilter[])new QFilter[]{filter});
        List ids = Arrays.stream(relations).map(v -> v.getLong("preinstbillid")).collect(Collectors.toList());
        filter = new QFilter("id", "in", ids);
        DynamicObject[] preInstBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"id,writeoffamt,actpreinstamt,writeoffamt,nowriteoffamt,writeoffstatus,batchnoid,actualinstamt", (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> relationsGroup = Arrays.stream(relations).collect(Collectors.groupingBy(v -> v.getLong("preinstbillid")));
        for (DynamicObject preInstBill : preInstBills) {
            DynamicObject relation = relationsGroup.get(preInstBill.getLong("id")).get(0);
            SettleIntWriteOffHelper.updatePreIntBill((DynamicObject)preInstBill, (BigDecimal)relation.getBigDecimal("amount"), (boolean)false);
        }
        SaveServiceHelper.save((DynamicObject[])preInstBills);
        SaveServiceHelper.save((DynamicObject[])interestBills);
        logger.info("executeUnWriteOff delete ifm_instWriteOff_relation");
        filter = new QFilter("batchnoid", "=", (Object)batchNoId);
        DeleteServiceHelper.delete((String)"ifm_instwriteoff_relation", (QFilter[])filter.toArray());
    }
}

