/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.interest;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentIntBillWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("intobject");
        selector.add("writeoffstatus");
        selector.add("writeoffdate");
        selector.add("batchnoid");
        selector.add("bechargeinstamt");
        selector.add("thischargeinstamt");
        selector.add("afterchargeinstamt");
        selector.add("afterchargeinstamt");
        selector.add("actualinstamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String writeOffParam = (String)this.getOperationVariable().get("param_writeoff");
        Map paramDataMap = EmptyUtil.isNoEmpty((String)writeOffParam) ? (Map)JSON.parseObject((String)writeOffParam, Map.class) : Collections.emptyMap();
        Map<Object, List<DynamicObject>> dataMap = Arrays.stream(dataEntities).filter(v -> CurrentBizTypeEnum.isCurrentInt((String)v.getString("biztype"))).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("intobject"))).collect(Collectors.groupingBy(r -> r.getDynamicObject("intobject").getPkValue()));
        for (List<DynamicObject> interestBills : dataMap.values()) {
            this.executeWriteOff(interestBills.toArray(new DynamicObject[0]), paramDataMap);
        }
    }

    private void executeWriteOff(DynamicObject[] interestBills, Map paramDataMap) {
        BigDecimal writeOffAmt = !CollectionUtils.isEmpty((Map)paramDataMap) ? (BigDecimal)paramDataMap.get("writeoffamt") : Arrays.stream(interestBills).map(v -> v.getBigDecimal("actualinstamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        long batchNoId = DBServiceHelper.genGlobalLongId();
        String preIntBillIdsStr = (String)paramDataMap.get("preIntBillIds");
        List preIntBillIds = EmptyUtil.isNoEmpty((String)preIntBillIdsStr) ? (List)JSON.parseObject((String)preIntBillIdsStr, List.class) : null;
        Object[] preIntBills = SettleIntWriteOffHelper.getPreIntBills((DynamicObject[])interestBills, (List)preIntBillIds);
        BigDecimal noWriteOffAmt = SettleIntWriteOffHelper.getTotalPreIntBillAmt((DynamicObject[])preIntBills);
        BigDecimal afterChargeInstAmt = noWriteOffAmt.subtract(writeOffAmt);
        for (DynamicObject interestBill : interestBills) {
            interestBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
            interestBill.set("writeoffdate", (Object)DateUtils.getCurrentDate());
            interestBill.set("batchnoid", (Object)batchNoId);
            interestBill.set("bechargeinstamt", (Object)noWriteOffAmt);
            BigDecimal thisChargeInstAmt = writeOffAmt.min(noWriteOffAmt);
            interestBill.set("thischargeinstamt", (Object)thisChargeInstAmt);
            interestBill.set("afterchargeinstamt", (Object)(afterChargeInstAmt.compareTo(BigDecimal.ZERO) > 0 ? afterChargeInstAmt : BigDecimal.ZERO));
        }
        SettleIntWriteOffHelper.writeOffPreInts((DynamicObject[])preIntBills, (BigDecimal)writeOffAmt, (long)batchNoId);
        if (EmptyUtil.isNoEmpty((Object[])interestBills) && EmptyUtil.isNoEmpty((Object[])preIntBills)) {
            SaveServiceHelper.save((DynamicObject[])interestBills);
            SaveServiceHelper.save((DynamicObject[])preIntBills);
        }
    }
}

