/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.interest;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InterestbillctgEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.mservice.consistency.helper.IfmConsistencyServiceHelper;

public class IfmInterestBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List ias = super.getSelector();
        ias.add("creditortype");
        ias.add("settlestatus");
        ias.add("instbillctg");
        ias.add("sourcebillid");
        ias.add("loanbillno");
        ias.add("combineinst");
        ias.add("repaymentid");
        ias.add("isrelcash");
        ias.add("eassrcid");
        return ias;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        OperateOption option = OperateOption.create();
        option.setVariableValue("repaymentFlag", "true");
        for (DynamicObject interestBill : dataEntities) {
            TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_interestbill", (Object[])new Object[]{interestBill.getLong("id")}, (OperateOption)option);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        ArrayList<Object> autoPushBills = new ArrayList<Object>();
        for (DynamicObject interestBill : dataEntities) {
            String instBillCtg = interestBill.getString("instbillctg");
            if (InterestbillctgEnum.isPrePayint((String)instBillCtg) || !this.isAutoPush(interestBill)) continue;
            if (InterestbillctgEnum.isPayprinandinte((String)instBillCtg)) {
                boolean intCom = interestBill.getBoolean("combineinst");
                long repaymentId = interestBill.getLong("repaymentid");
                String loanBillNo = interestBill.getString("loanbillno");
                DynamicObject loanbill = QueryServiceHelper.queryOne((String)"ifm_loanbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)loanBillNo)});
                QFilter repayLoanEntryQfiler = new QFilter("loans.e_loanbill.id", "=", (Object)loanbill.getLong("id")).and(new QFilter("id", "=", (Object)repaymentId));
                DynamicObject repayInfo = QueryServiceHelper.queryOne((String)"ifm_repaymentbill", (String)"billno,loans,loans.e_loanbill,loans.e_combineinst", (QFilter[])repayLoanEntryQfiler.toArray());
                if (intCom || !EmptyUtil.isNoEmpty((DynamicObject)repayInfo) || repayInfo.getBoolean("loans.e_combineinst")) continue;
                autoPushBills.add(interestBill.getPkValue());
                continue;
            }
            if (!InterestbillctgEnum.isPayinterst((String)instBillCtg)) continue;
            autoPushBills.add(interestBill.getPkValue());
        }
        this.pushPayInfo(autoPushBills);
    }

    private boolean isAutoPush(DynamicObject intBill) {
        return intBill.getBoolean("isrelcash") && EmptyUtil.isEmpty((String)intBill.getString("eassrcid"));
    }

    private void pushPayInfo(List<Object> autoPushBillIds) {
        if (EmptyUtil.isNoEmpty(autoPushBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"push2transhandle", (String)"ifm_interestbill", (Object[])autoPushBillIds.toArray(), (OperateOption)OperateOption.create());
            IfmConsistencyServiceHelper.asyncPush((String)"intBill_asyncPushPay", (String)"interestBillPushPayService", autoPushBillIds);
        }
    }
}

