/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.intobject;

import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;

public class IntObjectBankBatchSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            HashSet<DynamicObject> intObjects = new HashSet<DynamicObject>(16);
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                intObjects.add(this.genIntObject(entry, dataEntity));
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_bankacctintobject", (DynamicObject[])intObjects.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    private DynamicObject genIntObject(DynamicObject entry, DynamicObject data) {
        DynamicObject intObject = BusinessDataServiceHelper.newDynamicObject((String)"ifm_bankacctintobject");
        DynamicObjectUtil.copy((DynamicObject)data, (DynamicObject)intObject, (String[])new String[]{"entryentity"});
        DynamicObject bankAcct = entry.getDynamicObject("intobject");
        intObject.set("intobject", (Object)bankAcct);
        intObject.set("number", (Object)bankAcct.getString("number"));
        intObject.set("intinneracct", (Object)entry.getDynamicObject("intinneracct"));
        intObject.set("initaccum", (Object)entry.getBigDecimal("initaccum"));
        intObject.set("intfreeamt", (Object)entry.getBigDecimal("intfreeamt"));
        intObject.set("org", (Object)bankAcct.getDynamicObject("company"));
        intObject.set("accountorg", (Object)bankAcct.getDynamicObject("openorg"));
        intObject.set("currency", entry.getDynamicObject("currency").getPkValue());
        intObject.set("name", (Object)entry.getString("name"));
        Date date = new Date();
        intObject.set("enabledate", (Object)date);
        intObject.set("createtime", (Object)date);
        intObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        intObject.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        intObject.set("enable", (Object)"1");
        intObject.set("biztype", (Object)IntObjectTypeEnum.BANKACCT.getValue());
        intObject.set("interestratedays", (Object)data.getString("interestratedays"));
        intObject.set("lastpreintdate", (Object)data.getDate("lastintdate"));
        return intObject;
    }
}

