/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.loanbill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.helper.IfmLoanWriteBackHelper;
import kd.tmc.ifm.mservice.consistency.helper.IfmConsistencyServiceHelper;

public class IfmLoanBillAuditService
extends AbstractTmcBizOppService {
    private Set<Long> loanPush2CasSet = new HashSet<Long>(16);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bankcheckflag");
        selector.add("settleintmode");
        selector.add("isrelcash");
        selector.add("eassrcid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject loanBill : dataEntities) {
            IfmLoanWriteBackHelper.writeBackContract((DynamicObject)loanBill);
            if (this.isYkx(loanBill)) continue;
            this.push2RectransBill(loanBill);
        }
    }

    private void push2RectransBill(DynamicObject loanBill) {
        if (BizDealHelper.isCanPush2IfmBill((DynamicObject)loanBill)) {
            QFilter[] qFilters = new QFilter("sourcebillid", "=", (Object)loanBill.getLong("id")).toArray();
            TmcOperateServiceHelper.execOperate((String)"push2rectransbill", (String)"ifm_loanbill", (Object[])new Object[]{loanBill.getLong("id")}, (OperateOption)OperateOption.create());
            DynamicObject recTransBill = QueryServiceHelper.queryOne((String)"ifm_rectransbill", (String)"bankcheckflag", (QFilter[])qFilters);
            if (EmptyUtil.isNoEmpty((DynamicObject)recTransBill)) {
                loanBill.set("bankcheckflag", (Object)recTransBill.getString("bankcheckflag"));
                this.loanPush2CasSet.add(loanBill.getLong("id"));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        for (DynamicObject loanBill : dataEntities) {
            if (this.isYkx(loanBill)) continue;
            TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_loanbill", (Object[])new Object[]{loanBill.getLong("id")}, (OperateOption)OperateOption.create());
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject loanBill : dataEntities) {
            if (!this.isYkx(loanBill)) continue;
            TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_loanbill", (Object[])new Object[]{loanBill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
            this.push2RectransBill(loanBill);
        }
        this.doAutoPushCasBill();
    }

    private boolean isYkx(DynamicObject loanBill) {
        return SettleIntModeEnum.ykx.getValue().equals(loanBill.getString("settleintmode"));
    }

    private void doAutoPushCasBill() {
        if (EmptyUtil.isNoEmpty(this.loanPush2CasSet)) {
            IfmConsistencyServiceHelper.asyncPush((String)"loanBill_autoPush", (String)"loanBillPushRecService", new ArrayList<Long>(this.loanPush2CasSet));
        }
    }
}

