/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.payacceptancebill;

import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;

public class PayAcceptanceBackService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayAcceptanceBackService.class);

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("bizstatus", (Object)PayAcceptBizStatusEnum.REFUSED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject[] casPayBills;
        HashSet pkValueSet = new HashSet();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> pkValueSet.add((Long)dynamicObject.get("sourcebillid")));
        for (DynamicObject casPayBill : casPayBills = BusinessDataServiceHelper.load((Object[])pkValueSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"))) {
            casPayBill.set("bankreturnmsg", dynamicObjects[0].get("reason"));
            casPayBill.set("backuser", dynamicObjects[0].get("backuser"));
            casPayBill.set("backdate", dynamicObjects[0].get("backdate"));
            casPayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            casPayBill.set("iscommitbe", (Object)"0");
            casPayBill.set("bankpaystatus", (Object)" ");
        }
        OperationResult opResult = null;
        try {
            opResult = TmcOperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])casPayBills, (OperateOption)OperateOption.create(), (boolean)true);
        }
        catch (Exception e) {
            logger.error("\u9000\u5355\u64cd\u4f5c\u65f6\u53cd\u5199\u51fa\u7eb3\u4ed8\u6b3e\u5355\u72b6\u6001\u65f6\u51fa\u9519\u3002", (Throwable)e);
        }
        if (opResult == null || !opResult.isSuccess()) {
            // empty if block
        }
    }
}

