/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.product;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.ServiceCategoryEnum;

public class ProductSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("status");
        selector.add("servicecategory");
        selector.add("floatdirection");
        selector.add("hist_entry");
        selector.add("e_effectivedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            if (Objects.equals(ServiceCategoryEnum.DEPOSIT.getValue(), dataEntity.get("servicecategory"))) {
                dataEntity.set("floatdirection", null);
            }
            this.resortEntryData(dataEntity);
        }
    }

    private void resortEntryData(DynamicObject dataEntity) {
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("hist_entry");
        List list = entry.stream().sorted(Comparator.comparing(r -> r.getDate("e_effectivedate"))).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            ((DynamicObject)list.get(i)).set("seq", (Object)(i + 1));
        }
        entry.clear();
        entry.addAll(list);
    }
}

