/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.rectransbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.VoucherHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.RecTransPayStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class RecTransSaveService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(RecTransSaveService.class);
    private List<Long> transDetailIds = new ArrayList<Long>();

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, Long> billIdToSorgMap = new HashMap<Long, Long>(dataEntities.length);
        for (DynamicObject transBill : dataEntities) {
            if (transBill.get("sourcebilltype") != null && "fca_transupbill".equals(transBill.getString("sourcebilltype"))) {
                transBill.set("transtype", (Object)TransTypeEnum.INNER_FUND_COLLECTION.getValue());
            }
            String genCode = GenBankcheckCode.genCode();
            Object bankFlag = transBill.get("bankcheckflag");
            if (null != bankFlag && EmptyUtil.isEmpty((String)bankFlag.toString())) {
                transBill.set("bankcheckflag", (Object)genCode);
            }
            this.createTransDetail(transBill);
            DynamicObject scorg = transBill.getDynamicObject("scorg");
            if (!EmptyUtil.isNoEmpty((DynamicObject)scorg)) continue;
            billIdToSorgMap.put(transBill.getLong("id"), scorg.getLong("id"));
        }
        VoucherHelper.voucherWhiteListOpe((String)"ifm_rectransbill", (String)"audit", new ArrayList(billIdToSorgMap.keySet()), billIdToSorgMap, (boolean)true);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            String transType = (String)dataEntity.get("transtype");
            if (!transType.equals(TransTypeEnum.INNER_FUND_COLLECTION.getValue())) continue;
            JournalBookHelper.doBookJournal((DynamicObject)dataEntity);
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"matchbillintelrec", () -> TransDetailHelper.matchBillByBankCheckFlag(this.transDetailIds, (boolean)false));
    }

    private void createTransDetail(DynamicObject transBill) {
        transBill.set("paidstatus", (Object)RecTransPayStatusEnum.PAID.getValue());
        DynamicObject[] transDetailArr = TransDetailService.createTransDetail((DynamicObject)transBill);
        String transType = (String)transBill.get("transtype");
        if (TransTypeEnum.INNER_DEDUCTION.getValue().equals(transType) || TransTypeEnum.INNER_FUND_COLLECTION.getValue().equals(transType) || TransDetailHelper.isNeedMatchCasBill((String)transType)) {
            List detailIds = TransDetailHelper.getTransDetails((DynamicObject[])transDetailArr, (boolean)false);
            this.transDetailIds.addAll(detailIds);
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> cancleSuccessPks = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dt : dataEntities) {
            String transType = dt.getString("transtype");
            if (!transType.equals(TransTypeEnum.INNER_FUND_COLLECTION.getValue())) continue;
            cancleSuccessPks.add((Long)dt.getPkValue());
        }
        JournalBookHelper.cancelJournal((String)dataEntities[0].getDataEntityType().getName(), cancleSuccessPks);
    }
}

