/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.helper.IfmLoanWriteBackHelper;

public class IfmRepaymentUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loans");
        selector.add("e_ispayinst");
        selector.add("e_loanbill");
        selector.add("datasource");
        selector.add("bankcheckflag");
        return selector;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        for (ExtendedDataEntity dynamicObjects : dataEntities) {
            DynamicObject repay = dynamicObjects.getDataEntity();
            for (DynamicObject entry : repay.getDynamicObjectCollection("loans")) {
                boolean isPayInst = entry.getBoolean("e_ispayinst");
                if (!isPayInst) continue;
                QFilter intFilter = new QFilter("sourcebillid", "=", entry.getDynamicObject("e_loanbill").getPkValue()).and(new QFilter("repaymentid", "=", repay.getPkValue()));
                DynamicObject intBill = BizDealHelper.updateSrcBillInfo((String)"cfm_interestbill", (String)"settlestatus,bankcheckflag", (QFilter)intFilter);
                BizDealHelper.deleteInnerSettlePayRec((DynamicObject)intBill, (String)"ifm_transhandlebill");
            }
        }
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject repayBill : dynamicObjects) {
            BizDealHelper.deleteInnerSettlePayRec((DynamicObject)repayBill, (String)"ifm_transhandlebill");
            TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)"ifm_repaymentbill", (Object[])new Object[]{repayBill.getLong("id")}, (OperateOption)OperateOption.create());
            BizDealHelper.deleteBatchIntBill((DynamicObject)repayBill, (String)"ifm_intbill_batch_loan");
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject repayBill : dataEntities) {
            IfmLoanWriteBackHelper.writeBack((DynamicObject)repayBill);
        }
        this.deleteRecInfo(dataEntities);
    }

    private void deleteRecInfo(DynamicObject[] dataEntities) {
        Object[] ids = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        BizDealHelper.asyncDelRecPayInfo((Object[])ids, (boolean)true);
    }
}

