/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.bean.DeductionPayBean;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.TransSourceTypeEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;

public class TransHandleBillBackService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TransHandleBillBackService.class);

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(10);
        list.add("sourcebilltype");
        list.add("sourcebillentryid");
        list.add("sourcebillid");
        list.add("bankpaystatus");
        return list;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList casId = new ArrayList(10);
        ArrayList transId = new ArrayList(10);
        ArrayList<DeductionPayBean> deductionPayBeans = new ArrayList<DeductionPayBean>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject[] sourceBillType = (DynamicObject[])dynamicObject.get("sourcebilltype");
            if (TransSourceTypeEnum.IFM_PAYACCEPTANCEBILL.getValue().equals(sourceBillType)) {
                Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"ifm_transhandlebill", (Long[])new Long[]{(Long)dynamicObject.getPkValue()});
                for (Map.Entry recBillI : sourceBills.entrySet()) {
                    HashSet sourceIds = (HashSet)recBillI.getValue();
                    if (!CollectionUtils.isEmpty((Collection)sourceIds) && "cas_paybill".equals(recBillI.getKey())) {
                        casId.add(sourceIds.iterator().next());
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)sourceIds) || !"ifm_payacceptancebill".equals(recBillI.getKey())) continue;
                    transId.add(sourceIds.iterator().next());
                }
                continue;
            }
            if (!TransSourceTypeEnum.IFM_DEDUCTION.getValue().equals(sourceBillType)) continue;
            Long deductionBillId = (Long)dynamicObject.get("sourcebillid");
            Long sourceBillEntryId = (Long)dynamicObject.get("sourcebillentryid");
            DeductionPayBean deductionPayBean = new DeductionPayBean();
            deductionPayBean.setBillId(deductionBillId);
            deductionPayBean.setEntryRowId(sourceBillEntryId);
            deductionPayBean.setReturnMessage((String)dynamicObjects[0].get("reason"));
            deductionPayBeans.add(deductionPayBean);
        }
        if (deductionPayBeans.size() > 0) {
            DeductionPayHelper.payBack(deductionPayBeans);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ifm_payacceptancebill");
        DynamicObject[] transObjects = BusinessDataServiceHelper.load((Object[])transId.toArray(), (DynamicObjectType)type);
        DynamicObject[] casObjects = BusinessDataServiceHelper.load((Object[])casId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        DynamicObject transBill = dynamicObjects[0];
        for (DynamicObject transObject : transObjects) {
            transObject.set("reason", transBill.get("reason"));
            transObject.set("backuser", transBill.get("backuser"));
            transObject.set("backdate", transBill.get("backdate"));
            transObject.set("bizstatus", (Object)PayAcceptBizStatusEnum.REFUSED.getValue());
            transObject.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        for (DynamicObject casObject : casObjects) {
            casObject.set("bankreturnmsg", transBill.get("reason"));
            casObject.set("backuser", transBill.get("backuser"));
            casObject.set("backdate", transBill.get("backdate"));
            casObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            casObject.set("iscommitbe", (Object)"0");
            casObject.set("bankpaystatus", (Object)transBill.getString("bankpaystatus"));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        SaveServiceHelper.save((DynamicObject[])transObjects);
        OperationResult opResult = null;
        try {
            opResult = TmcOperateServiceHelper.execOperate((String)"chargebacksave", (String)"cas_paybill", (DynamicObject[])casObjects, (OperateOption)OperateOption.create(), (boolean)true);
        }
        catch (Exception e) {
            logger.error("\u9000\u5355\u64cd\u4f5c\u65f6\u53cd\u5199\u51fa\u7eb3\u4ed8\u6b3e\u5355\u72b6\u6001\u65f6\u51fa\u9519\u3002", (Throwable)e);
        }
        if (opResult == null || !opResult.isSuccess()) {
            // empty if block
        }
    }
}

