/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;

public class TransHandleBillBitbackService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("paidstatus");
        sel.add("commitbetime");
        sel.add("paydate");
        sel.add("bankpaystatus");
        sel.add("bankreturnmsg");
        sel.add("iscommitbe");
        sel.add("sourcebilltype");
        sel.add("sourcebillid");
        sel.add("isbitback");
        sel.add("bitbackopinion");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String bitBackOpinion = (String)this.getOperationVariable().get("bitbackopinion");
        ArrayList<DynamicObject> bill = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject billData : dataEntities) {
            billData.set("paidstatus", (Object)TransBillPaidStatusEnum.WAITING.getValue());
            billData.set("commitbetime", null);
            billData.set("iscommitbe", (Object)false);
            billData.set("paydate", null);
            billData.set("isbitback", (Object)true);
            billData.set("bitbackopinion", (Object)bitBackOpinion);
            bill.add(billData);
        }
        SaveServiceHelper.save((DynamicObject[])bill.toArray(new DynamicObject[0]));
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Map<Long, Long> transAcceptMap = Arrays.stream(dataEntities).filter(o -> "ifm_payacceptancebill".equals(o.getString("sourcebilltype"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("sourcebillid")));
        if (EmptyUtil.isEmpty(transAcceptMap) || transAcceptMap.size() == 0) {
            return;
        }
        DynamicObjectCollection payAcceptColl = QueryServiceHelper.query((String)"ifm_payacceptancebill", (String)"id,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", transAcceptMap.values())});
        Map<Long, Long> acceptCasMap = payAcceptColl.stream().filter(o -> "cas_paybill".equals(o.getString("sourcebilltype"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("sourcebillid")));
        if (EmptyUtil.isEmpty(acceptCasMap) || acceptCasMap.size() == 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            Long acceptId = transAcceptMap.get(dataEntity.getLong("id"));
            SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)dataEntity.getLong("id"), (Long)acceptCasMap.get(acceptId), (String)"");
            syncStatusInfo.setCommitBe(false);
            syncStatusInfo.setCommitBeTime(null);
            List detailList = syncStatusInfo.getDetailList();
            for (SyncStatusDetail detail : detailList) {
                detail.setEbStatusMsg(dataEntity.getString("bankreturnmsg"));
            }
            syncStatusInfo.setBankPayStatus(dataEntity.getString("bankpaystatus"));
            syncStatusInfo.setBitBack(true);
            syncStatusInfo.setBitBackOpinion(dataEntity.getString("bitbackopinion"));
            BankBillSyncStatusHelper.syncPaymentBill((SyncStatusInfo)syncStatusInfo, null, null, (boolean)true);
        }
    }
}

