/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.task;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.ListUtils;

public class InnerAcctUpdateTransDetailTask
extends AbstractTask {
    private static final String UPDATE_TRANSDETAIL_BILLSTATUS = "update t_bei_transdetail set fbillstatus = 'C' where faccountbankid in (%s) and fbillstatus != 'C'";
    private static final Log logger = LogFactory.getLog(InnerAcctUpdateTransDetailTask.class);

    public void execute(RequestContext context, Map<String, Object> paramMap) throws KDException {
        logger.info("InnerAcctUpdateTransDetailTask execute begin");
        List<Object> accountBankIds = this.queryInnerAcctAccountBankIds();
        if (accountBankIds.isEmpty()) {
            logger.info("inner account is empty");
            return;
        }
        logger.info("InnerAcctUpdateTransDetailTask inner account count: {}", (Object)accountBankIds.size());
        List accountIdList = ListUtils.splitList(accountBankIds, (long)200L);
        for (List accountIds : accountIdList) {
            String ids = accountIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            DB.update((DBRoute)DBRouteConst.TMC, (String)String.format(UPDATE_TRANSDETAIL_BILLSTATUS, ids));
        }
        logger.info("InnerAcctUpdateTransDetailTask execute end");
    }

    private List<Object> queryInnerAcctAccountBankIds() {
        QFilter filter = new QFilter("inneracct", ">", (Object)0).and("finorgtype", "=", (Object)"1");
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])filter.toArray(), null, (int)-1);
    }
}

