/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.accountacceptance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.helper.InnerAcctBusHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class AccountAcceptSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("businesstype");
        selector.add("accountbank");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        Map acctBankMaps = new HashMap(dataEntity.length);
        Set acctIds = Arrays.stream(dataEntity).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDataEntity().getDynamicObject("accountbank"))).map(o -> o.getDataEntity().getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(acctIds)) {
            acctBankMaps = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id,currency,company", (QFilter[])new QFilter("id", "in", acctIds).toArray());
        }
        for (ExtendedDataEntity entity : dataEntity) {
            boolean journalIsCheck;
            boolean isValidata;
            DynamicObject data = entity.getDataEntity();
            if (!BusinessTypeEnum.CLOSE.getValue().equals(data.getString("businesstype"))) continue;
            DynamicObject accountBank = data.getDynamicObject("accountbank");
            if (EmptyUtil.isEmpty((DynamicObject)(accountBank = (DynamicObject)acctBankMaps.get(accountBank.getLong("id"))))) continue;
            long companyId = accountBank.getDynamicObject("company").getLong("id");
            boolean isNeedCheck = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.AM.getId(), (long)companyId, (String)"bankacctclosectrl");
            if (!isNeedCheck) continue;
            String checkBillParams = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.AM.getId(), (long)companyId, (String)"bankacctclosectrlitem");
            long bankAcctId = accountBank.getLong("id");
            String validataMsg = InnerAcctBusHelper.getValidataMsg("cas_paybill", bankAcctId, checkBillParams, "pay");
            if (EmptyUtil.isNoEmpty((String)validataMsg)) {
                this.addErrorMessage(entity, ifmBizResource.getCloseacctExistpbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (EmptyUtil.isNoEmpty((String)(validataMsg = InnerAcctBusHelper.getValidataMsg("cas_recbill", bankAcctId, checkBillParams, "rec")))) {
                this.addErrorMessage(entity, ifmBizResource.getCloseacctExistrbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (EmptyUtil.isNoEmpty((String)(validataMsg = InnerAcctBusHelper.getValidataMsg("cas_agentpaybill", bankAcctId, checkBillParams, "agent")))) {
                this.addErrorMessage(entity, ifmBizResource.getCloseacctExistagentpbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (!(isValidata = InnerAcctBusHelper.validataBalance(accountBank, checkBillParams))) {
                this.addWarningMessage(entity, ifmBizResource.getTipCasamt());
            }
            if (!checkBillParams.contains("journalcheck") || (journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)accountBank))) continue;
            this.addWarningMessage(entity, ifmBizResource.getTipCascheck());
        }
    }
}

