/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.accountacceptance;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class AccountAcceptanceHandleValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            if (!Objects.equals(data.getString("businesstype"), BusinessTypeEnum.OPEN.getValue())) continue;
            String acctNum = data.getString("bankaccountnumber");
            QFilter numFilter = new QFilter("number", "=", (Object)acctNum);
            QFilter openBankFilter = new QFilter("finorg", "=", data.getDynamicObject("bank").getPkValue());
            boolean isAcctNumExist = TmcDataServiceHelper.exists((String)"ifm_inneracct", (QFilter[])new QFilter[]{numFilter, openBankFilter});
            if (isAcctNumExist) {
                this.addErrorMessage(entity, ifmBizResource.getCheckBankAccountNumber());
            }
            if (!data.getDate("opendate").after(new Date())) continue;
            this.addErrorMessage(entity, ifmBizResource.checkOpenDate());
        }
    }
}

