/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.accountfrozen;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;

public class InnerAccountFrozenSaveValidator
extends AbstractTmcBizOppValidator {
    private static final String TMC_IFM_BUSINESS = "tmc-ifm-business";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("frozenenddate");
        selector.add("account");
        selector.add("account.number");
        selector.add("account.acctstatus");
        selector.add("settlecenter");
        selector.add("applydate");
        selector.add("auditdate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!this.checkFrozenAmountForSave(dataEntity)) continue;
            this.checkAccountFrozenRecordsForSave(dataEntity);
        }
    }

    private boolean checkFrozenAmountForSave(ExtendedDataEntity extendedDataEntity) {
        DynamicObject accountFrozen = extendedDataEntity.getDataEntity();
        if (EmptyUtil.isEmpty((DynamicObject)accountFrozen)) {
            return false;
        }
        DynamicObject innerAccount = accountFrozen.getDynamicObject("account");
        if (EmptyUtil.isEmpty((DynamicObject)innerAccount)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5185\u90e8\u8d26\u6237\u201d\u3002", (String)"InnerAccountFrozenSaveValidator_3", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        BigDecimal frozenAmount = accountFrozen.getBigDecimal("frozenamount");
        BigDecimal totalFrozenAmount = accountFrozen.getBigDecimal("totalfrozenamount");
        String frozenType = accountFrozen.getString("frozentype");
        InnerAccountFrozenTypeEnum frozenTypeEnum = InnerAccountFrozenTypeEnum.getByValue((String)frozenType);
        switch (frozenTypeEnum) {
            case AMOUNT_FROZEN: {
                if (frozenAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"InnerAccountFrozenSaveValidator_6", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
                    return false;
                }
                BigDecimal latestAccountBlance = InnerAccountBalanceHelper.getInnerAcctCurBalance((Long)innerAccount.getLong("id"), (Date)new Date());
                if (latestAccountBlance.compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u8d26\u6237\u6700\u65b0\u4f59\u989d\u201d\u4e3a0\u6216\u7a7a\u65f6\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u91d1\u989d\u51bb\u7ed3\u548c\u91d1\u989d\u89e3\u51bb\u5355\u636e\u3002", (String)"InnerAccountFrozenSaveValidator_7", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
                    return false;
                }
                BigDecimal avaiableAmount = latestAccountBlance.subtract(totalFrozenAmount);
                if (frozenAmount.compareTo(avaiableAmount) <= 0) break;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u91d1\u989d\u201d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6240\u9009\u8d26\u6237\u7684\u53ef\u51bb\u7ed3\u4f59\u989d\u3002", (String)"InnerAccountFrozenSaveValidator_0", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
            case AMOUNT_THAW: {
                if (frozenAmount.compareTo(totalFrozenAmount) <= 0) break;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u91d1\u989d\u201d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7d2f\u8ba1\u51bb\u7ed3\u91d1\u989d\u3002", (String)"InnerAccountFrozenSaveValidator_1", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void checkAccountFrozenRecordsForSave(ExtendedDataEntity extendedDataEntity) {
        DynamicObject accountFrozen = extendedDataEntity.getDataEntity();
        if (this.isExistFrozeningBill(accountFrozen)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u201c\u5185\u90e8\u8d26\u6237\u201d\u5df2\u6709\u672a\u5ba1\u6838\u8bb0\u5f55\uff0c\u8bf7\u5148\u5ba1\u6838\u3002", (String)"InnerAccountFrozenSubmitValidator_3", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
        }
    }

    private boolean isExistFrozeningBill(DynamicObject accountFrozen) {
        DynamicObject frozenAccountDo = accountFrozen.getDynamicObject("account");
        String billNo = accountFrozen.getString("billno");
        Long accountId = frozenAccountDo.getLong("id");
        QFilter qFilter = new QFilter("account", "=", (Object)accountId).and("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}).and("billno", "!=", (Object)billNo);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"ifm_accountfrozen", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)accounts);
    }
}

