/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bankint.preint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.WriteOffStatusEnum;

public class BankPreIntUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("intobject");
        selector.add("writeoffstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String operateByBatch = (String)this.getOption().getVariables().get("operatebybatch");
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateStatus(extendedDataEntity);
            this.validateLastPreInt(extendedDataEntity);
            if (!EmptyUtil.isNoEmpty((String)operateByBatch)) continue;
            this.validateChanged(extendedDataEntity);
        }
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        String bizType = bankPreInt.getString("biztype");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)"reverseint")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u53cd\u5ba1\u6838\u64cd\u4f5c\u7c7b\u522b\u4e3a\u9884\u63d0\u5229\u606f\u7684\u5355\u636e", (String)"BankPreIntUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else {
            String writeOffStatus = bankPreInt.getString("writeoffstatus");
            if (!StringUtils.equals((CharSequence)writeOffStatus, (CharSequence)WriteOffStatusEnum.NO_WRITEOFF.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u9884\u63d0\u5355\u88ab\u51b2\u9500\u9884\u63d0\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"BankPreIntUnAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateLastPreInt(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        DynamicObject intObject = bankPreInt.getDynamicObject("intobject");
        QFilter qFilter = new QFilter("biztype", "=", (Object)"preint");
        qFilter.and(new QFilter("intobject", "=", intObject.getPkValue()));
        Object[] intBills = TmcDataServiceHelper.load((String)bankPreInt.getDataEntityType().getName(), (String)"id", (QFilter[])qFilter.toArray(), (String)"interestday desc, createtime desc");
        if (EmptyUtil.isNoEmpty((Object[])intBills) && !intBills[0].getPkValue().equals(bankPreInt.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6700\u540e\u4e00\u6b21\u9884\u63d0\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"BankPreIntUnAuditValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateChanged(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankInt = extendedDataEntity.getDataEntity();
        if (bankInt.getBoolean("ischanged")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"BankPreIntUnAuditValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

