/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bankint.settle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankIntUnAuditValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String operateByBatch = (String)this.getOption().getVariables().get("operatebybatch");
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateDownBill(extendedDataEntity);
            this.validateLastBill(extendedDataEntity);
            if (!EmptyUtil.isNoEmpty((String)operateByBatch)) continue;
            this.validateChanged(extendedDataEntity);
        }
    }

    private void validateDownBill(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankInt = extendedDataEntity.getDataEntity();
        DynamicObject recBill = TmcBotpHelper.getTargetBill((String)bankInt.getDataEntityType().getName(), (Object)bankInt.getPkValue(), (String)"cas_recbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)recBill)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"BankIntUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateLastBill(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankInt = extendedDataEntity.getDataEntity();
        DynamicObject intObject = bankInt.getDynamicObject("intobject");
        Object[] intBills = TmcDataServiceHelper.load((String)bankInt.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter("intobject", "=", intObject.getPkValue()).toArray(), (String)"interestday desc, createtime desc");
        if (EmptyUtil.isNoEmpty((Object[])intBills) && !intBills[0].getPkValue().equals(bankInt.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6700\u540e\u4e00\u6b21\u7ed3\u606f\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"BankIntUnAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateChanged(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankInt = extendedDataEntity.getDataEntity();
        if (bankInt.getBoolean("ischanged")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"BankIntUnAuditValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

