/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bankint.writeoff;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankPreIntWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("writeoffstatus");
        selector.add("intobject");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateStatus(extendedDataEntity);
            this.validateLastPreInt(extendedDataEntity);
        }
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        String bizType = bankPreInt.getString("biztype");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)"reverseint")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u9884\u63d0\u5229\u606f\u624d\u5141\u8bb8\u8fdb\u884c\u7ea2\u5b57\u51b2\u9500\u3002", (String)"BankPreIntWriteOffValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else {
            String writeOffStatus;
            String status = bankPreInt.getString("billstatus");
            if (!StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u672a\u51b2\u9500\u5355\u636e\u624d\u5141\u8bb8\u51b2\u9500\u3002", (String)"BankPreIntWriteOffValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)(writeOffStatus = bankPreInt.getString("writeoffstatus")), (CharSequence)"no_writeoff")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u88ab\u51b2\u9500\u9884\u63d0\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ea2\u5b57\u51b2\u9500\u3002", (String)"BankPreIntWriteOffValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateLastPreInt(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        DynamicObject intObject = bankPreInt.getDynamicObject("intobject");
        QFilter qfilter = new QFilter("intobject", "=", intObject.getPkValue());
        qfilter.and(new QFilter("writeoffstatus", "=", (Object)"no_writeoff"));
        Object[] intBills = TmcDataServiceHelper.load((String)bankPreInt.getDataEntityType().getName(), (String)"id", (QFilter[])qfilter.toArray(), (String)"interestday desc, createtime desc");
        if (EmptyUtil.isNoEmpty((Object[])intBills) && !intBills[0].getPkValue().equals(bankPreInt.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6700\u540e\u4e00\u6b21\u9884\u63d0\u64cd\u4f5c\u8fdb\u884c\u7ea2\u5b57\u51b2\u9500\u3002", (String)"BankPreIntWriteOffValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

