/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bizdeal;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.BizDealStatusEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class BizDealCenterChargeBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("dealopinion");
        selector.add("businessstatus");
        selector.add("applitype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity ede : dataEntity) {
            String dealopinion;
            DynamicObject billDyn = BusinessDataServiceHelper.loadSingle((String)"ifm_bizdealbill", (String)"billstatus,dealopinion,businessstatus", (QFilter[])new QFilter("id", "=", ede.getBillPkId()).toArray());
            String billstatus = billDyn.getString("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billstatus)) {
                this.addErrorMessage(ede, ifmBizResource.checkBillStatusChargedBack());
            }
            if (EmptyUtil.isEmpty((String)(dealopinion = ede.getDataEntity().getString("dealopinion")))) {
                this.addErrorMessage(ede, ifmBizResource.checkChargeBackOpinionNotNull());
            }
            String businessstatus = billDyn.getString("businessstatus");
            if (!BizDealStatusEnum.CHARGEBACK.getValue().equals(businessstatus)) continue;
            this.addErrorMessage(ede, ifmBizResource.checkBizStatus());
        }
    }
}

