/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.crosspay;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;

public class CrossPaySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("iscrosspay");
        selector.add("crosstrantype");
        selector.add("payeebank");
        selector.add("paybank");
        selector.add("payerbank");
        selector.add("reccountry");
        selector.add("agentfinorg");
        selector.add("paymentchannel");
        selector.add("deductiontype");
        selector.add("reccity");
        selector.add("recprovince");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Boolean isUserInGroup = LicenseServiceHelper.checkPerformGroup((String)"PRO_MAP").getHasLicense();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            boolean isCrossPay = data.getBoolean("iscrosspay");
            this.checkMustInputReceive(extendedDataEntity, data);
            if (!isCrossPay) continue;
            if (!isUserInGroup.booleanValue()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u8de8\u5883\u94f6\u4f01\u652f\u4ed8\u7684\u4ea7\u54c1\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"CrossPaySubmitValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (!this.validateViewInput(extendedDataEntity)) continue;
            this.validateSameBankLimit(extendedDataEntity);
            this.validateCountryLimit(extendedDataEntity);
        }
    }

    private boolean validateViewInput(ExtendedDataEntity extendedDataEntity) {
        DynamicObject data = extendedDataEntity.getDataEntity();
        DynamicObject crossTranType = data.getDynamicObject("crosstrantype");
        if (null == crossTranType) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8de8\u5883\u4ea4\u6613\u7c7b\u578b\u3002", (String)"CrossPaySubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        crossTranType = TmcDataServiceHelper.loadSingle((Object)crossTranType.getPkValue(), (String)"bei_crosstrantype");
        DynamicObjectCollection entries = crossTranType.getDynamicObjectCollection("entry");
        entries.removeIf(v -> !v.getBoolean("issee"));
        Map<String, String> fieldsMap = this.getFieldMap(data);
        for (DynamicObject entry : entries) {
            String fieldKey = entry.getString("fieldkey");
            String string = fieldKey = "transtype".equals(fieldKey) ? "transtypes" : fieldKey;
            if (!fieldsMap.containsKey(fieldKey)) continue;
            Object value = data.get(fieldKey);
            this.checkMustInput(extendedDataEntity, value, entry);
            this.checkFieldLen(extendedDataEntity, value, entry);
        }
        return this.getValidateResult().isSuccess();
    }

    private void validateSameBankLimit(ExtendedDataEntity extendedDataEntity) {
        DynamicObject data = extendedDataEntity.getDataEntity();
        DynamicObject crossTransType = data.getDynamicObject("crosstrantype");
        boolean isLimitSameBank = crossTransType.getBoolean("islimitsamebank");
        if (isLimitSameBank) {
            boolean flag = true;
            DynamicObject payeeBank = this.loadComplexProp(data.getDynamicObject("payeebank"));
            DynamicObject payBank = this.loadComplexProp(data.getDynamicObject(this.getPayBank(data)));
            if (null != payeeBank && null != payBank) {
                boolean bl = flag = this.compareCode(payeeBank, payBank, "swift_code", 4) || this.compareCode(payeeBank, payBank, "union_number", 3);
            }
            if (!flag) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u7c7b\u578b\u9650\u5b9a\u540c\u884c\u4ea4\u6613\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4ea4\u6613\u7c7b\u578b\u3002", (String)"CrossPaySubmitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateCountryLimit(ExtendedDataEntity extendedDataEntity) {
        DynamicObject data = extendedDataEntity.getDataEntity();
        DynamicObject crossTransType = data.getDynamicObject("crosstrantype");
        boolean isCountryLimit = (crossTransType = TmcDataServiceHelper.loadSingleFromCache((Object)crossTransType.getPkValue(), (String)"bei_crosstrantype")).getBoolean("iscountry");
        if (isCountryLimit) {
            DynamicObject recCountry = data.getDynamicObject("reccountry");
            DynamicObjectCollection limitCountrys = crossTransType.getDynamicObjectCollection("country");
            List limitCountyIds = limitCountrys.stream().map(v -> v.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            if (null != recCountry && EmptyUtil.isNoEmpty(limitCountyIds) && !limitCountyIds.contains(recCountry.getPkValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u7c7b\u578b\u652f\u6301\u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u5305\u62ec[%s]\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4ea4\u6613\u7c7b\u578b\u3002", (String)"CrossPaySubmitValidator_2", (String)"tmc-ifm-business", (Object[])new Object[]{recCountry.getString("name")}));
            }
        }
    }

    private void checkMustInput(ExtendedDataEntity dataEntity, Object value, DynamicObject entry) {
        boolean isMustInput = entry.getBoolean("isnotnull");
        if (isMustInput && EmptyUtil.isEmpty((Object)value)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d", (String)"CrossPaySubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]), entry.getString("fieldname")));
        }
    }

    private void checkMustInputReceive(ExtendedDataEntity dataEntity, DynamicObject entry) {
        String entityName = dataEntity.getDataEntity().getDataEntityType().getName();
        if (!"ifm_transhandlebill".equals(entityName) && !"ifm_deduction".equals(entityName)) {
            return;
        }
        boolean isCrossPay = entry.getBoolean("iscrosspay");
        String paymentChannel = entry.getString("paymentchannel");
        boolean isTran = Boolean.FALSE;
        isTran = "ifm_transhandlebill".equals(entityName) ? Boolean.TRUE.booleanValue() : DeductionTypeEnum.CENTER_AGENT.getValue().equals(entry.getString("deductiontype"));
        if (isTran && PaymentChanEnum.BEI.getValue().equals(paymentChannel)) {
            Object reccity = entry.get("reccity");
            Object recprovince = entry.get("recprovince");
            if (EmptyUtil.isEmpty((Object)reccity)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u201d", (String)"CrossPaySubmitValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (!isCrossPay && EmptyUtil.isEmpty((Object)recprovince)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7701\u4efd\uff08\u94f6\u4f01\uff09\u201d", (String)"CrossPaySubmitValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkFieldLen(ExtendedDataEntity dataEntity, Object value, DynamicObject entry) {
        String fieldType = entry.getString("fieldtype");
        boolean isLimitLen = entry.getBoolean("islimitlength");
        if (isLimitLen && fieldType.endsWith("text") && null != value) {
            int maxLength = entry.getInt("maxlength");
            if (((String)value).length() > maxLength) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s", (String)"CrossPaySubmitValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]), entry.getString("fieldname"), maxLength));
            }
        }
    }

    private String getPayBank(DynamicObject data) {
        return data.getDynamicObjectType().getName().equals("ifm_deduction") ? "paybank" : "agentfinorg";
    }

    private boolean compareCode(DynamicObject leftObj, DynamicObject rightObj, String field, int len) {
        String left = leftObj.getString(field);
        String right = rightObj.getString(field);
        if (EmptyUtil.isEmpty((String)left) && EmptyUtil.isEmpty((String)right)) {
            return true;
        }
        if (EmptyUtil.isEmpty((String)left) || EmptyUtil.isEmpty((String)right) || left.length() < len || right.length() < len) {
            return false;
        }
        return right.startsWith(left.substring(0, len));
    }

    private Map<String, String> getFieldMap(DynamicObject info) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        DataEntityPropertyCollection properties = info.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProps = p.getDynamicCollectionItemPropertyType().getProperties();
                entryProps.forEach(prop -> fieldMap.put(prop.getName(), "entry"));
                continue;
            }
            fieldMap.put(property.getName(), "head");
        }
        return fieldMap;
    }

    private DynamicObject loadComplexProp(DynamicObject obj) {
        if (null != obj) {
            return TmcDataServiceHelper.loadSingleFromCache((Object)obj.getPkValue(), (String)obj.getDynamicObjectType().getName());
        }
        return null;
    }
}

