/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deduction;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.helper.TransBillHelper;

public class DeductionSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject payIdenty;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String deductionType = dataEntity.getString("deductiontype");
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                BigDecimal payAmt = row.getBigDecimal("payamount");
                if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deductionType)) {
                    if (!EmptyUtil.isEmpty((BigDecimal)payAmt)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"DeductionSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (!EmptyUtil.isEmpty((BigDecimal)payAmt) && payAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91d1\u989d\u9700\u5927\u4e8e0\u3002", (String)"DeductionSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[]{i + 1}));
            }
            String checkResult = TransBillHelper.checkTranDetailToDeduction((DynamicObject)dataEntity);
            if (EmptyUtil.isNoEmpty((String)checkResult)) {
                this.addErrorMessage(extendedDataEntity, checkResult);
            }
            if (!DeductionTypeEnum.isCenterAgent((Object)deductionType) && "0".equals((payIdenty = dataEntity.getDynamicObject("paymentidentify")).getString("type"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u975e\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u6807\u8bc6\u4e0d\u652f\u6301\u4e3b\u52a8\u4ed8\u6b3e\u3002", (String)"DeductionSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (dataEntity.getBigDecimal("receiveamount").compareTo(Constants.MAX_AMOUNT) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, new TmcBizResource().checkAmountMaxValue(((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"receiveamount")).getDisplayName().getLocaleValue()));
        }
    }
}

