/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.helper.TransBillHelper;
import org.apache.commons.lang.StringUtils;

public class DeductionSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("receiveamount");
        selector.add("payamount");
        selector.add("transfercomment");
        selector.add("payeetype");
        selector.add("deductiontype");
        selector.add("scorg");
        selector.add("paybankaccount");
        selector.add("paybank");
        selector.add("payeeaccountbank");
        selector.add("payee");
        selector.add("payeename");
        selector.add("payeebanknum");
        selector.add("receivecompany");
        selector.add("receiveaccount");
        selector.add("paymentchannel");
        selector.add("recaccbankname");
        selector.add("recbanknumber");
        selector.add("payeebank");
        selector.add("settletype");
        selector.add("openorg");
        selector.add("paymentidentify");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("receivecurrency");
        selector.add("iscrosspay");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String checkResult;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String deductionType = dataEntity.getString("deductiontype");
            if (dataEntity.getBigDecimal("receiveamount").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u6761\u6263\u6b3e\u660e\u7ec6\u3002", (String)"DeductionSubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (dataEntity.getBigDecimal("receiveamount").compareTo(Constants.MAX_AMOUNT) > 0) {
                this.addErrorMessage(extendedDataEntity, new TmcBizResource().checkAmountMaxValue(((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"receiveamount")).getDisplayName().getLocaleValue()));
            }
            if (EmptyUtil.isNoEmpty((String)(checkResult = TransBillHelper.checkTranDetailToDeduction((DynamicObject)dataEntity)))) {
                this.addErrorMessage(extendedDataEntity, checkResult);
            }
            if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType)) {
                if (EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("paymentidentify"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u6536\u6b3e\u4eba\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)dataEntity.getString("payeetype"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u6807\u8bc6\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_16", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)dataEntity.getString("scorg"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u4eba\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)dataEntity.getString("paybankaccount"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u8d26\u53f7\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)dataEntity.getString("paybank"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u94f6\u884c\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            } else {
                DynamicObject payIdenty = dataEntity.getDynamicObject("paymentidentify");
                if ("0".equals(payIdenty.getString("type"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u975e\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u4ed8\u6b3e\u6807\u8bc6\u4e0d\u652f\u6301\u4e3b\u52a8\u4ed8\u6b3e\u3002", (String)"DeductionSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            boolean isCheckEntryComment = false;
            if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType)) {
                DynamicObjectCollection settlementTypes;
                DynamicObject payBankAccount = dataEntity.getDynamicObject("paybankaccount");
                DynamicObject settleType = dataEntity.getDynamicObject("settletype");
                DynamicObjectCollection dynamicObjectCollection = settlementTypes = payBankAccount != null ? payBankAccount.getDynamicObjectCollection("settlementtype") : null;
                if (settlementTypes != null && settlementTypes.size() > 0) {
                    Set settleTypeIds = settlementTypes.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                    Map settleTypeMap = TmcDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", settleTypeIds)});
                    Set settleTypeNames = settleTypeMap.values().stream().map(o -> o.getString("name")).collect(Collectors.toSet());
                    if (settleType != null && !settleTypeIds.contains(settleType.getPkValue())) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u548c\u4ed8\u6b3e\u8d26\u53f7\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f[%s]\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeductionSubmitValidator_14", (String)"tmc-ifm-business", (Object[])new Object[]{StringUtils.join(settleTypeNames, (String)",")}));
                    }
                }
                String paymentChannel = dataEntity.getString("paymentchannel");
                if (payBankAccount != null && payBankAccount.getBoolean("issetbankinterface") && PaymentChanEnum.BEI.getValue().equals(paymentChannel)) {
                    DynamicObject payeeBank;
                    String recBankNumber;
                    isCheckEntryComment = true;
                    String recaccBankName = dataEntity.getString("recaccbankname");
                    if (EmptyUtil.isEmpty((String)recaccBankName)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u4eba\u5b9e\u540d\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    if (EmptyUtil.isEmpty((String)(recBankNumber = dataEntity.getString("recbanknumber")))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u884c\u53f7\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    if (EmptyUtil.isEmpty((DynamicObject)(payeeBank = dataEntity.getDynamicObject("payeebank")))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u94f6\u884c\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_8", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    } else {
                        String city;
                        DynamicObject country = payeeBank.getDynamicObject("country");
                        String payBankName = payeeBank.getString("name");
                        if (EmptyUtil.isEmpty((DynamicObject)country)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u94f6\u884c[%s]\u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionSubmitValidator_9", (String)"tmc-ifm-business", (Object[])new Object[0]), payBankName));
                        }
                        boolean isCrossPay = dataEntity.getBoolean("iscrosspay");
                        String province = payeeBank.getString("provincetxt");
                        if (!isCrossPay && EmptyUtil.isEmpty((String)province)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u94f6\u884c[%s]\u7684\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionSubmitValidator_10", (String)"tmc-ifm-business", (Object[])new Object[0]), payBankName));
                        }
                        if (EmptyUtil.isEmpty((String)(city = payeeBank.getString("citytxt")))) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u94f6\u884c[%s]\u7684\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionSubmitValidator_11", (String)"tmc-ifm-business", (Object[])new Object[0]), payBankName));
                        }
                    }
                    String payeeBankNum = dataEntity.getString("payeebanknum");
                    if (EmptyUtil.isEmpty((String)payeeBankNum)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6536\u6b3e\u8d26\u53f7\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_12", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                }
            }
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                BigDecimal payAmt = row.getBigDecimal("payamount");
                if (DeductionTypeEnum.AGENT_DEDUCTION.getValue().equals(deductionType)) {
                    if (EmptyUtil.isEmpty((BigDecimal)payAmt)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"DeductionSubmitValidator_15", (String)"tmc-ifm-business", (Object[])new Object[]{i + 1}));
                    }
                } else if (EmptyUtil.isEmpty((BigDecimal)payAmt) || payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91d1\u989d\u9700\u5927\u4e8e0\u3002", (String)"DeductionSubmitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[]{i + 1}));
                }
                if (!isCheckEntryComment || !EmptyUtil.isEmpty((String)row.getString("transfercomment"))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u652f\u4ed8\uff0c\u6263\u6b3e\u660e\u7ec6\u7b2c%s\u884c\u8f6c\u8d26\u9644\u8a00\u5fc5\u5f55\u3002", (String)"DeductionSubmitValidator_13", (String)"tmc-ifm-business", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

