/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.extintobject;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.intobject.IntObjectBaseSaveValidator;
import kd.tmc.ifm.enums.IntObjectTypeEnum;

public class ExtIntBeaObjectSaveValidator
extends IntObjectBaseSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("intobject");
        selector.add("startintdate");
        selector.add("lastintdate");
        selector.add("currency");
        return selector;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            Long extIntObjId = null;
            DynamicObject extIntObject = BusinessDataServiceHelper.loadSingle((String)"ifm_bankacctintobject", (String)"id,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
            if (EmptyUtil.isEmpty((DynamicObject)extIntObject)) {
                Date startIntdate = data.getDate("startintdate");
                Date lastIntdate = data.getDate("lastintdate");
                if (lastIntdate.after(startIntdate)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u6b21\u7ed3\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"ExtIntBeaObjectSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            } else {
                extIntObjId = extIntObject.getLong("id");
            }
            if (this.validateDuplicate(data)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u8be5\u94f6\u884c\u8d26\u6237\u7684\u8ba1\u606f\u5bf9\u8c61\uff0c\u8bf7\u786e\u8ba4\u518d\u4fdd\u5b58\u3002", (String)"ExtIntBeaObjectSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (this.checkNameExists(data, extIntObjId)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\uff0c\u8bf7\u786e\u8ba4\u518d\u4fdd\u5b58\u3002", (String)"ExtIntBeaObjectSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            super.validateIntEntries(extendedDataEntity);
        }
    }

    private boolean validateDuplicate(DynamicObject extIntObject) {
        Object intObjectId = extIntObject.getDynamicObject("intobject").getPkValue();
        QFilter filter = new QFilter("intobject", "=", intObjectId).and("id", "!=", extIntObject.getPkValue()).and("currency", "=", (Object)extIntObject.getLong("currency.id")).and("biztype", "=", (Object)IntObjectTypeEnum.BANKACCT.getValue()).and("datasource", "in", Arrays.asList("bankjournal", "bei"));
        return TmcDataServiceHelper.exists((String)"ifm_bankacctintobject", (QFilter[])filter.toArray());
    }

    private boolean checkNameExists(DynamicObject extIntObject, Long objPk) {
        String name = extIntObject.getString("name");
        QFilter filter = new QFilter("name", "=", (Object)name);
        if (objPk != null) {
            filter.and("id", "!=", (Object)objPk);
        }
        return TmcDataServiceHelper.exists((String)"ifm_bankacctintobject", (QFilter[])filter.toArray());
    }
}

