/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.inneracct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAcctDeleteValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashMap<Object, ExtendedDataEntity> pkExtEntityMap = new HashMap<Object, ExtendedDataEntity>(16);
        ArrayList<Object> ids = new ArrayList<Object>(dataEntities.length);
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", InnerAcctHelper.INNERACCT_IGNORE_REF_ON_DELETE));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List acctBankRefs;
            pkExtEntityMap.put(dataEntity.getBillPkId(), dataEntity);
            ids.add(dataEntity.getBillPkId());
            DynamicObject bankAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)dataEntity.getDataEntity());
            if (bankAcct == null || (acctBankRefs = InnerAcctHelper.getRefEntityNames((String)"bd_accountbanks", (Object)bankAcct.getPkValue(), (List)InnerAcctHelper.BANKACCT_IGNORE_REF_ON_DELETE)).isEmpty()) continue;
            this.addErrorMessage(dataEntity, InnerAcctHelper.buildRefMessage((List)acctBankRefs));
        }
        QFilter qf = new QFilter("inneraccount.id", "in", ids);
        qf.and(new QFilter("isinit", "=", (Object)true));
        Object[] initBills = TmcDataServiceHelper.load((String)"ifm_inneraccountinit", (String)"id, inneraccount.id", (QFilter[])qf.toArray());
        if (EmptyUtil.isNoEmpty((Object[])initBills)) {
            for (Object initBill : initBills) {
                ExtendedDataEntity entity = (ExtendedDataEntity)pkExtEntityMap.get(initBill.getDynamicObject("inneraccount").getPkValue());
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u7ecf\u521d\u59cb\u5316", (String)"InnerAcctDeleteValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }
}

