/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.helper.InterestCalcHelper;

public class CurrentIntBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("begindate");
        selector.add("intobject");
        selector.add("batchno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
            String bizType = currentIntBill.getString("biztype");
            if (CurrentBizTypeEnum.isCurrentInt((String)bizType)) {
                this.validateIntDate(extendedDataEntity);
                continue;
            }
            if (CurrentBizTypeEnum.isPreInt((String)bizType)) {
                this.validatePreIntDate(extendedDataEntity);
                continue;
            }
            if (!CurrentBizTypeEnum.isReversePreInt((String)bizType)) continue;
            this.validateWriteOff(extendedDataEntity);
        }
    }

    private void validateIntDate(ExtendedDataEntity extendedDataEntity) {
        boolean isSameDate;
        DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
        DynamicObject intObject = currentIntBill.getDynamicObject("intobject");
        if (EmptyUtil.isEmpty((DynamicObject)intObject)) {
            return;
        }
        intObject = TmcDataServiceHelper.loadSingle((String)"ifm_intobject", (String)"begindate,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", intObject.getPkValue())});
        Date beginDate = currentIntBill.getDate("begindate");
        Date lastIntDate = intObject.getDate("lastintdate");
        boolean bl = isSameDate = DateUtils.formatString((Date)DateUtils.getLastDay((Date)beginDate, (int)1), (String)"yyyyMMdd").compareTo(DateUtils.formatString((Date)lastIntDate, (String)"yyyyMMdd")) == 0;
        if (EmptyUtil.isNoEmpty((Object)lastIntDate) && EmptyUtil.isNoEmpty((Object)beginDate) && !isSameDate) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61%s\u7684\u4e0a\u6b21\u7ed3\u606f\u65e5\u5df2\u7ecf\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"CurrentIntBillSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]), intObject.getString("name")));
        }
    }

    private void validatePreIntDate(ExtendedDataEntity extendedDataEntity) {
        boolean isSameDate;
        DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
        DynamicObject intObject = currentIntBill.getDynamicObject("intobject");
        if (EmptyUtil.isEmpty((DynamicObject)intObject)) {
            return;
        }
        intObject = TmcDataServiceHelper.loadSingle((String)"ifm_intobject", (String)"begindate,lastpreintdate,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", intObject.getPkValue())});
        Date beginDate = currentIntBill.getDate("begindate");
        Date lastPreIntDate = InterestCalcHelper.getIntObjectStartPreIntDate((DynamicObject)intObject);
        boolean bl = isSameDate = DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd").compareTo(DateUtils.formatString((Date)lastPreIntDate, (String)"yyyyMMdd")) == 0;
        if (EmptyUtil.isNoEmpty((Object)lastPreIntDate) && EmptyUtil.isNoEmpty((Object)beginDate) && !isSameDate) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61%s\u7684\u4e0a\u6b21\u9884\u63d0\u65e5\u5df2\u7ecf\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"CurrentIntBillSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]), intObject.getString("number")));
        }
    }

    private void validateWriteOff(ExtendedDataEntity extendedDataEntity) {
        DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
        DynamicObject innerAcct = currentIntBill.getDynamicObject("inneracct");
        Date beginDate = currentIntBill.getDate("begindate");
        QFilter qFilter = new QFilter("inneracct", "=", innerAcct.getPkValue());
        qFilter.and(new QFilter("begindate", "=", (Object)beginDate));
        qFilter.and(new QFilter("biztype", "=", (Object)"reversepreint"));
        qFilter.and(new QFilter("batchno", "=", (Object)currentIntBill.getString("batchno")));
        if (TmcDataServiceHelper.exists((String)"ifm_currentintbill", (QFilter[])qFilter.toArray())) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u76f8\u540c\u65e5\u671f\u7684\u51b2\u9500\u9884\u63d0\u5355\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u51b2\u9500\u3002", (String)"CurrentIntBillSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]), innerAcct.getString("number")));
        }
    }
}

