/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentIntBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("begindate");
        selector.add("intobject");
        selector.add("batchno");
        selector.add("writeoffstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set<Long> billIds = Arrays.stream(dataEntity).map(o -> o.getDataEntity()).filter(o -> CurrentBizTypeEnum.isCurrentInt((String)o.getString("biztype"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Map<Long, String> checkFailBillIds = this.validateDetail(billIds);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
            String bizType = currentIntBill.getString("biztype");
            if (!CurrentBizTypeEnum.isCurrentInt((String)bizType)) continue;
            this.validateOrder(extendedDataEntity);
            if (!checkFailBillIds.containsKey(currentIntBill.getLong("id"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7684\u5185\u90e8\u4ea4\u6613\u660e\u7ec6[%s]\u4e0d\u662f\u5bf9\u8d26\u6807\u8bc6\u7801\u5339\u914d\u6216\u81ea\u52a8\u5339\u914d\u5165\u8d26\uff0c\u4e0d\u80fd\u81ea\u52a8\u53d6\u6d88\u5339\u914d\uff0c\u8bf7\u5728\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u624b\u5de5\u53d6\u6d88\u5165\u8d26\u3002", (String)"CurrentIntBillUnAuditValidate_2", (String)"tmc-ifm-business", (Object[])new Object[]{checkFailBillIds.get(currentIntBill.getLong("id"))}));
        }
        this.validateDtxLock(dataEntity);
    }

    private Map<Long, String> validateDetail(Set<Long> billIds) {
        HashMap<Long, String> checkFailBillMap = new HashMap<Long, String>();
        if (EmptyUtil.isEmpty(billIds)) {
            return checkFailBillMap;
        }
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"ifm_rectransbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)recBills)) {
            return checkFailBillMap;
        }
        Map<Long, Long> recTocurrentMap = recBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("sourcebillid"), (v1, v2) -> v2));
        Set recBillIds = recBills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_intelrec", (String)"sourcebillid,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", recBillIds).and("receredtype", "=", (Object)ReceredtypeEnum.ACCOUNTED.getValue()).and("smartmatch", "!=", (Object)MatchStatusEnum.SMARTMATCH.getValue()).and("receredway", "!=", (Object)"beipay")});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)transDetails)) {
            return checkFailBillMap;
        }
        for (DynamicObject transDetail : transDetails) {
            Long currentBillId = recTocurrentMap.get(transDetail.getLong("sourcebillid"));
            if (EmptyUtil.isEmpty((Long)currentBillId)) continue;
            checkFailBillMap.put(currentBillId, transDetail.getString("billno"));
        }
        return checkFailBillMap;
    }

    private void validateOrder(ExtendedDataEntity extendedDataEntity) {
        if (!this.getValidateResult().isSuccess()) {
            return;
        }
        DynamicObject currentIntBill = extendedDataEntity.getDataEntity();
        DynamicObject lastIntBill = SettleIntWriteOffHelper.getLastIntBill((DynamicObject)currentIntBill, (String)CurrentBizTypeEnum.CURRENTINT.getValue());
        if (null != lastIntBill && !lastIntBill.getPkValue().equals(currentIntBill.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u5229\u606f\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CurrentIntBillUnAuditValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateDtxLock(ExtendedDataEntity[] dataEntity) {
        List ids = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getString("id")).collect(Collectors.toList());
        List lockedBizIds = TxCheckUtil.loadUnfinishedTx(ids);
        if (EmptyUtil.isEmpty((Collection)lockedBizIds)) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String id = extendedDataEntity.getDataEntity().getString("id");
            if (!lockedBizIds.contains(id)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u606f\u5355\u5ba1\u6838\u4e0b\u63a8\u6536\u6b3e\u5904\u7406\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\u6267\u884c\u5931\u8d25\u6216\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CurrentIntBillUnAuditValidate_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

