/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PreIntWayEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentIntBillWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("settlecenter");
        selector.add("intobject");
        selector.add("writeoffstatus");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateStatus(extendedDataEntity) || !this.validateWriteOffParam(extendedDataEntity)) continue;
            this.validateExistPreInt(extendedDataEntity);
        }
    }

    private boolean validateStatus(ExtendedDataEntity extendedDataEntity) {
        DynamicObject interestBill = extendedDataEntity.getDataEntity();
        String billStatus = interestBill.getString("billstatus");
        String writeOffStatus = interestBill.getString("writeoffstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue()) || !StringUtils.equals((CharSequence)writeOffStatus, (CharSequence)WriteOffStatusEnum.NO_WRITEOFF.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u672a\u51b2\u9500\u5355\u636e\u5141\u8bb8\u51b2\u9500\u3002", (String)"CurrentIntBillWriteOffValidate_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateWriteOffParam(ExtendedDataEntity extendedDataEntity) {
        DynamicObject currentInt = extendedDataEntity.getDataEntity();
        DynamicObject settleCenter = currentInt.getDynamicObject("settlecenter");
        String preIntWay = SettleIntWriteOffHelper.getPreIntWay((DynamicObject)settleCenter);
        if (EmptyUtil.isEmpty((String)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5", (String)"CurrentPreIntBillRedWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.equals((CharSequence)PreIntWayEnum.QECXF.getValue(), (CharSequence)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5\u4e3a\uff1a\u201c\u5168\u989d\u51b2\u9500\u6cd5\u201d", (String)"CurrentIntBillWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateExistPreInt(ExtendedDataEntity extendedDataEntity) {
        DynamicObject interestBill = extendedDataEntity.getDataEntity();
        Object[] preIntBills = SettleIntWriteOffHelper.getPreIntBills((DynamicObject[])new DynamicObject[]{interestBill}, null);
        if (EmptyUtil.isEmpty((Object[])preIntBills)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u51b2\u9500\u7684\u9884\u63d0\u5355\u8bb0\u5f55\u3002", (String)"CurrentIntBillWriteOffValidate_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

