/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.intobject;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntEntryTypeEnum;
import kd.tmc.ifm.enums.InterestWayEnum;
import kd.tmc.ifm.enums.RangeItemEnum;

public class IntObjectBaseSaveValidator
extends AbstractTmcBizOppValidator {
    private static final String SYSTEM_TYPE = "tmc-ifm-business";

    public List<String> getSelector() {
        List sels = super.getSelector();
        sels.add("interestway");
        sels.add("iscaloverint");
        sels.add("depositint_entry");
        sels.add("depositamtbegin");
        sels.add("depositamtend");
        sels.add("overint_entry");
        sels.add("depositbegin");
        sels.add("depositend");
        return sels;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
    }

    protected void validateIntEntries(ExtendedDataEntity extendedDataEntity) {
        DynamicObject data = extendedDataEntity.getDataEntity();
        if (InterestWayEnum.isProgression((Object)data.getString("interestway"))) {
            this.validateIntEntry(extendedDataEntity, "depositint_entry", "depositamtbegin", "depositamtend");
            if (data.getBoolean("iscaloverint")) {
                this.validateIntEntry(extendedDataEntity, "overint_entry", "depositbegin", "depositend");
            }
        }
    }

    private void validateIntEntry(ExtendedDataEntity dataEntity, String entryKey, String depBeginKey, String depEndKey) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection entry = data.getDynamicObjectCollection(entryKey);
        String entryTypeName = IntEntryTypeEnum.getNameByKey((String)entryKey);
        int size = entry.size();
        int lastRowIdx = size - 1;
        for (int i = 0; i < size; ++i) {
            boolean lastLessThanPrevDepEnd;
            boolean nonFirst = i > 0;
            DynamicObject currRow = (DynamicObject)entry.get(i);
            DynamicObject prevRow = null;
            if (nonFirst) {
                prevRow = (DynamicObject)entry.get(i - 1);
                BigDecimal prevDepBegin = prevRow.getBigDecimal(depBeginKey);
                BigDecimal currDepBegin = currRow.getBigDecimal(depBeginKey);
                if (currDepBegin.compareTo(prevDepBegin) <= 0) {
                    this.addErrorMessage(dataEntity, this.getMustGreaterThanPrevRowTip(entryTypeName, i, RangeItemEnum.BEGIN));
                    return;
                }
            }
            BigDecimal currDepEnd = currRow.getBigDecimal(depEndKey);
            boolean isLast = i == lastRowIdx;
            boolean isPositiveInfinity = EmptyUtil.isEmpty((BigDecimal)currDepEnd);
            if (!isLast && isPositiveInfinity) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u5229\u7387\u914d\u7f6e\u201d\u7b2c{1}\u884c:\u201c\u7ed3\u675f\u503c\u201d\u3002", (String)"IntObjectSaveValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[]{entryTypeName, i + 1}));
                return;
            }
            if (!nonFirst || prevRow == null) continue;
            BigDecimal prevDepEnd = prevRow.getBigDecimal(depEndKey);
            boolean nonLastLessThanPrevDepEnd = !isLast && currDepEnd.compareTo(prevDepEnd) <= 0;
            boolean bl = lastLessThanPrevDepEnd = isLast && !isPositiveInfinity;
            if (!nonLastLessThanPrevDepEnd && !lastLessThanPrevDepEnd) continue;
            this.addErrorMessage(dataEntity, this.getMustGreaterThanPrevRowTip(entryTypeName, i, RangeItemEnum.END));
            return;
        }
    }

    private String getMustGreaterThanPrevRowTip(String entryTypeName, int rowIdx, RangeItemEnum itemEnum) {
        return ResManager.loadKDString((String)"\u201c{0}\u5229\u7387\u914d\u7f6e\u201d\u7b2c{1}\u884c:\u201c{2}\u503c\u201d\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u884c\u7684{3}\u503c\u3002", (String)"IntObjectSaveValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[]{entryTypeName, rowIdx + 1, itemEnum.getName(), itemEnum.getName()});
    }
}

