/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.intobject;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntObjectBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                DynamicObjectCollection innertAccts;
                Object[] intObjects;
                DynamicObject referRate;
                Stream<DynamicObject> entryStream = entrys.stream().filter(t -> t.getDynamicObject("intobject") != null);
                Set currIds = entryStream.map(o -> ((DynamicObject)o.getDynamicObject("intobject").getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                if (currIds.size() > 1) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u5185\u90e8\u94f6\u884c\u8d26\u6237\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"IntObjectBatchSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if ((referRate = data.getDynamicObject("referrate")) != null) {
                    Long currId = data.getDynamicObject("referrate").getDynamicObject("currency").getLong("id");
                    if (currIds.size() == 0 || currId.compareTo((Long)currIds.iterator().next()) != 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u5b58\u6b3e\u5229\u7387\u7684\u5e01\u79cd\u548c\u5185\u90e8\u94f6\u884c\u8d26\u6237\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"IntObjectBatchSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                }
                Set entryObjs = entrys.stream().filter(t -> t.getDynamicObject("intobject") != null).collect(Collectors.toSet());
                Set innertAcctIds = entrys.stream().filter(t -> t.getDynamicObject("intobject") != null).map(o -> o.getDynamicObject("intobject").getPkValue()).collect(Collectors.toSet());
                if (innertAcctIds.size() != entryObjs.size()) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u9009\u62e9\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntObjectSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((Object[])(intObjects = BusinessDataServiceHelper.load((String)"ifm_intobject", (String)"id,inneracct,intobject", (QFilter[])new QFilter[]{new QFilter("intobject", "in", innertAcctIds)})))) {
                    Set innertActNums = Arrays.stream(intObjects).map(o -> o.getDynamicObject("intobject").getString("number")).collect(Collectors.toSet());
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237[%s]\u5df2\u5173\u8054\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"IntObjectSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]), String.join((CharSequence)",", innertActNums)));
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(innertAccts = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", innertAcctIds), new QFilter("isdrawobject", "=", (Object)"1")})))) {
                    Set innertActNums = innertAccts.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237[%s]\u5df2\u5173\u8054\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"IntObjectSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]), String.join((CharSequence)",", innertActNums)));
                }
            } else {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"IntObjectSaveValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            Date startDate = data.getDate("startintdate");
            Date LastDate = data.getDate("lastintdate");
            if (startDate == null || LastDate == null || LastDate.compareTo(startDate) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u6b21\u7ed3\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f", (String)"IntObjectSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

