/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.mutxlock;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.MutexServiceHelper;

public class TmcBillMutexValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(TmcBillMutexValidator.class);

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        if (dataEntitys == null || dataEntitys.length == 0) {
            return;
        }
        List ids = Arrays.stream(dataEntitys).map(o -> String.valueOf(o.getDataEntity().getPkValue())).collect(Collectors.toList());
        Map lockMap = MutexServiceHelper.batchRequest(ids, (String)dataEntitys[0].getDataEntity().getDataEntityType().getName(), (String)"tmc_op_lock");
        try {
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                DynamicObject data = dataEntity.getDataEntity();
                if (lockMap.containsKey(data.getString("id")) && ((Boolean)lockMap.get(data.getString("id"))).booleanValue()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6570\u636e\u4e92\u65a5\u9501\u7533\u8bf7\u5931\u8d25\u3002", (String)"TmcBillMutexValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            MutexServiceHelper.batchRelease(ids, (String)dataEntitys[0].getDataEntity().getDataEntityType().getName(), (String)"tmc_op_lock");
        }
    }
}

