/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.payacceptancebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.ifm.enums.TransTypeEnum;

public class PayAcceptanceAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("agentfinorgcat");
        selector.add("agentpayeraccount");
        selector.add("agentpayeraccname");
        selector.add("agentfinorg");
        selector.add("billstatus");
        selector.add("payeeacctbank");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        TmcErrorCode paymentErrorCode = new TmcErrorCode();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            String transType = (String)extendedDataEntity.getValue("transtype");
            if (!TransTypeEnum.INNER_AGENT_PAY.getValue().equals(transType)) continue;
            DynamicObject payerAcctBank = info.getDynamicObject("agentpayeraccount");
            if (payerAcctBank == null) {
                this.addMessage(extendedDataEntity, String.format(paymentErrorCode.BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ee3\u4ed8\u8d26\u6237", (String)"PayAcceptanceAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0])));
                continue;
            }
            if (!this.isClosed(payerAcctBank.getLong("id"))) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PayAcceptanceAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]), payerAcctBank.getString("number")));
        }
    }

    public boolean isClosed(long acctBankId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "=", (Object)acctBankId).toArray());
        return "closing".equals(account.getString("acctstatus")) || "closed".equals(account.getString("acctstatus"));
    }
}

