/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.preint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class CurrentPreIntBillOnWayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("begindate");
        sic.add("enddate");
        sic.add("intobject");
        sic.add("biztype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        if (this.getOption().getVariables().containsKey("redwriteoffop")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject currentIntBill = dataEntity.getDataEntity();
            Date begindate = currentIntBill.getDate("begindate");
            Date enddate = currentIntBill.getDate("enddate");
            String biztype = currentIntBill.getString("biztype");
            if (!CurrentBizTypeEnum.isCurrentInt((String)biztype) && !CurrentBizTypeEnum.isPreInt((String)biztype)) {
                return;
            }
            long intobjectId = currentIntBill.getDynamicObject("intobject").getLong("id");
            long currentintpk = currentIntBill.getLong("id");
            List<Pair<String, String>> result = this.preIntValidate(begindate, enddate, intobjectId, currentintpk, biztype);
            for (Pair<String, String> p : result) {
                this.addMessage(dataEntity, (String)p.getRight(), "error".equals(p.getLeft()) ? ErrorLevel.Error : ErrorLevel.Warning);
            }
        }
    }

    public List<Pair<String, String>> preIntValidate(Date startinstdate, Date endinstdate, Long intobjectId, Long currentintpk, String biztype) {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        QFilter onwayStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        onwayStatusFilter.and(new QFilter("intobject", "=", (Object)intobjectId));
        onwayStatusFilter.and(new QFilter("id", "!=", (Object)currentintpk));
        onwayStatusFilter.and(new QFilter("biztype", "=", (Object)biztype));
        DynamicObjectCollection submitInterestBills = QueryServiceHelper.query((String)"ifm_currentintbill", (String)"billstatus", (QFilter[])new QFilter[]{onwayStatusFilter});
        if (submitInterestBills.size() >= 1) {
            results.add((Pair<String, String>)Pair.of((Object)"warm", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u606f\u5bf9\u8c61\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5229\u606f\u8bb0\u5f55\uff0c\u8bf7\u5148\u5904\u7406", (String)"CurrentPreIntBillOnWayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0])));
        }
        if (EmptyUtil.isNoEmpty((Object)startinstdate)) {
            QFilter idFilter = new QFilter("id", "!=", (Object)currentintpk);
            QFilter qfilter = new QFilter("intobject", "=", (Object)intobjectId);
            qfilter.and(new QFilter("writeoffstatus", "in", Arrays.asList("no_writeoff", "part_writeoff")));
            qfilter.and(new QFilter("biztype", "=", (Object)biztype));
            QFilter dateQFilter = new QFilter("begindate", "<", (Object)startinstdate).and("enddate", ">", (Object)startinstdate).or(new QFilter("begindate", "=", (Object)startinstdate)).or(new QFilter("begindate", ">", (Object)startinstdate).and("begindate", "<=", (Object)endinstdate));
            DynamicObjectCollection preintBills = QueryServiceHelper.query((String)"ifm_preintbill_bank", (String)"enddate", (QFilter[])new QFilter[]{idFilter, qfilter, dateQFilter}, (String)"enddate desc");
            if (EmptyUtil.isNoEmpty((Integer)preintBills.size())) {
                results.add((Pair<String, String>)Pair.of((Object)"error", (Object)ResManager.loadKDString((String)"\u9884\u63d0\u5355\u8d77\u606f\u65e5\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u8bf7\u5728\u5355\u636e\u9875\u9762\u786e\u8ba4\u540e\u63d0\u4ea4\u3002", (String)"CurrentPreIntBillOnWayValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0])));
            }
        }
        return results;
    }
}

