/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.preint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentPreIntUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("writeoffstatus");
        selector.add("biztype");
        selector.add("intobject");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateStatus(extendedDataEntity);
            this.validateOrder(extendedDataEntity);
        }
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity) {
        DynamicObject preIntBill = extendedDataEntity.getDataEntity();
        String writeOffStatus = preIntBill.getString("writeoffstatus");
        if (!StringUtils.equals((CharSequence)writeOffStatus, (CharSequence)WriteOffStatusEnum.NO_WRITEOFF.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u51b2\u9500\u7684\u5355\u636e\u624d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"CurrentPreIntUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateOrder(ExtendedDataEntity extendedDataEntity) {
        DynamicObject lastIntBill;
        DynamicObject preIntBill = extendedDataEntity.getDataEntity();
        if (CurrentBizTypeEnum.isPreInt((String)preIntBill.getString("biztype")) && null != (lastIntBill = SettleIntWriteOffHelper.getLastIntBill((DynamicObject)preIntBill, (String)CurrentBizTypeEnum.PREINT.getValue())) && !lastIntBill.getPkValue().equals(preIntBill.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u5229\u606f\u9884\u63d0\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CurrentPreIntUnAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

