/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.preint;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.ifm.enums.PreIntOperateTypeEnum;

public class PreIntBillBathUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("isinterest");
        selector.add("isreverse");
        selector.add("intdetailnum");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (this.getOption().containsVariable("operatebycurrent")) {
            return;
        }
        ArrayList entryIdList = new ArrayList(16);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObjectCollection dynamicObjectCollection = entity.getDataEntity().getDynamicObjectCollection("entry");
            entryIdList.addAll(dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        DynamicObject[] reverseBills = TmcDataServiceHelper.load((String)"ifm_intbill_batch_pre", (String)"entry,entry.sourceentryid", (QFilter[])new QFilter[]{new QFilter("entry.sourceentryid", "in", entryIdList), new QFilter("operatetype", "=", (Object)PreIntOperateTypeEnum.REVERSEINT.getValue())});
        entryIdList.clear();
        for (DynamicObject dynamicObject : reverseBills) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
            entryIdList.addAll(entrys.stream().map(row -> row.get("sourceentryid")).collect(Collectors.toList()));
        }
        block2: for (DynamicObject dynamicObject : dataEntity) {
            DynamicObject preIntBill = dynamicObject.getDataEntity();
            for (DynamicObject entry : preIntBill.getDynamicObjectCollection("entry")) {
                if (entryIdList.contains(entry.getPkValue())) {
                    this.addErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u9884\u63d0\u5229\u606f\u5355%s\u5b58\u5728\u5728\u9014\u7684\u51b2\u9500\u9884\u63d0\u5355\u636e\uff0c\u8bf7\u5148\u5904\u7406\u540e\u518d\u64cd\u4f5c\u3002", (String)"PreIntBillBathUnAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]), entry.getString("intdetailnum")));
                    continue block2;
                }
                if (!entry.getBoolean("isinterest") && !entry.getBoolean("isreverse")) continue;
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u5355\u636e\u5185\u660e\u7ec6\u8bb0\u5f55\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"PreIntBillBathUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue block2;
            }
        }
    }
}

