/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.product;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ProductSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("hist_entry");
        selector.add("e_effectivedate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject product = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = product.getDynamicObjectCollection("hist_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5229\u7387\u4fe1\u606f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductSaveValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            Set effectSet = entry.stream().map(r -> r.getDate("e_effectivedate")).collect(Collectors.toSet());
            if (effectSet.size() == entry.size()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u4e0d\u80fd\u5b58\u5728\u751f\u6548\u65e5\u671f\u76f8\u540c\u7684\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

