/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.rectransbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class RecTransSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("payeeaccountbank");
        selector.add("currency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject billDO = dataEntity.getDataEntity();
            DynamicObject accDO = billDO.getDynamicObject("payeeaccountbank");
            if (accDO == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecTransSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection accCcys = accDO.getDynamicObjectCollection("currency");
            DynamicObject currencyDO = billDO.getDynamicObject("currency");
            if (currencyDO == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"RecTransSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (accDO == null || currencyDO == null || accCcys.stream().anyMatch(o -> o.getDynamicObject("fbasedataid").getPkValue().equals(currencyDO.getPkValue()))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u5e01\u79cd\u548c\u6b3e\u5e01\u79cd\u4e0d\u4e00\u81f4", (String)"RecTransSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

