/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.settcentersetting;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class InnerAccountInitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("inneraccount");
        selector.add("amountdate");
        selector.add("amount");
        selector.add("currency");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List dts = Stream.of(dataEntity).map(v -> v.getDataEntity()).collect(Collectors.toList());
        List innerAccountIdList = dts.stream().map(e -> e.get("inneraccount.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("inneracct.id", "in", innerAccountIdList);
        DynamicObjectCollection accountIdInfo = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,inneracct.id,bank", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> innerAccountIdAndIdMap = accountIdInfo.stream().collect(Collectors.toMap(e -> e.getLong("inneracct.id"), e -> e.getLong("id"), (v1, v2) -> v2));
        List bankIds = accountIdInfo.stream().map(d -> d.getLong("bank")).collect(Collectors.toList());
        Map acceptDateMap = IfmSettleCenterHelper.getAcceptDateMap(bankIds);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject initDO = entity.getDataEntity();
            Long accountPkId = innerAccountIdAndIdMap.get(initDO.getLong("inneraccount.id"));
            String bankAccountNumber = initDO.getString("inneraccount.number");
            Date amountDate = (Date)initDO.get("amountdate");
            Date openDate = (Date)initDO.get("inneraccount.open_date");
            if (accountPkId == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u6ca1\u6709\u8be5\u6761\u6570\u636e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u3002", (String)"InnerAccountInitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
                continue;
            }
            boolean isInit = initDO.getBoolean("isinit");
            if (isInit) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u5df2\u521d\u59cb\u5316\u3002", (String)"InnerAccountInitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
                continue;
            }
            if (Objects.isNull(amountDate)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u8bf7\u8865\u5145\u4f59\u989d\u65e5\u671f\u3002", (String)"InnerAccountInitValidator_4", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
                continue;
            }
            if (openDate.after(amountDate)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"[%1$s]\uff1a\u4f59\u989d\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u6237\u65e5\u671f[%2$s]\u3002", (String)"InnerAccountInitValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]), bankAccountNumber, DateUtils.formatString((Date)openDate, (String)"yyyy-MM-dd")));
                continue;
            }
            Long bankId = (Long)initDO.getDynamicObject("inneraccount.finorg").getPkValue();
            Date acceptDate = (Date)acceptDateMap.get(bankId);
            if (acceptDate.after(amountDate)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"[%1$s]\uff1a\u4f59\u989d\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u53d7\u7406\u65e5\u671f[%2$s]\u3002", (String)"InnerAccountInitValidator_8", (String)"tmc-ifm-business", (Object[])new Object[0]), bankAccountNumber, DateUtils.formatString((Date)acceptDate, (String)"yyyy-MM-dd")));
                continue;
            }
            QFilter acctQFilter = new QFilter("accountbank.id", "=", (Object)accountPkId);
            acctQFilter.and("sourcebillid", "!=", (Object)accountPkId);
            acctQFilter.and("sourcebilltype", "!=", (Object)"bd_accountbanks");
            DynamicObjectCollection list = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id,bizdate", (QFilter[])new QFilter[]{acctQFilter}, (String)"bizdate asc, biztime asc", (int)1);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)list)) {
                Date bizdate = ((DynamicObject)list.get(0)).getDate("bizdate");
                if (!amountDate.after(bizdate)) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"[%1$s]\uff1a\u6700\u65e9\u4e00\u7b14\u4e1a\u52a1\u7684\u4ea4\u6613\u65e5\u671f[%2$s]\u4e0d\u80fd\u65e9\u4e8e\u4f59\u989d\u65e5\u671f\u3002", (String)"InnerAccountInitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]), bankAccountNumber, DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd")));
                continue;
            }
            QFilter acctInitQFilter = new QFilter("accountbank.id", "=", (Object)accountPkId);
            acctInitQFilter.and("sourcebillid", "=", (Object)accountPkId);
            acctInitQFilter.and("sourcebilltype", "=", (Object)"bd_accountbanks");
            if (!QueryServiceHelper.exists((String)"ifm_transdetail", (QFilter[])new QFilter[]{acctInitQFilter})) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u5df2\u521d\u59cb\u5316\u3002", (String)"InnerAccountInitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
        }
    }
}

