/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.resources.IfmBusResourceEnum;
import kd.tmc.ifm.business.validator.transhandlebill.AbstractTransBillCancelPayValidator;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class TransHandleBillCancelPayValidator
extends AbstractTransBillCancelPayValidator {
    @Override
    public List<String> getSelector() {
        List<String> sels = super.getSelector();
        sels.add("transtype");
        sels.add("paidstatus");
        sels.add("iscommitbe");
        sels.add("bankaccount");
        sels.add("sourcebilltype");
        sels.add("settletype");
        return sels;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<Long, ExtendedDataEntity> idEntityMap = this.toIdEntityMap(extendedDataEntities);
        ArrayList<Long> billIdsForCheckJournal = new ArrayList<Long>(extendedDataEntities.length);
        ArrayList<Long> checkVcIds = new ArrayList<Long>(extendedDataEntities.length);
        HashSet<Long> bankmentIds = new HashSet<Long>(extendedDataEntities.length);
        List lockedIds = new ArrayList();
        List bizBillIds = Arrays.stream(this.dataEntities).filter(o -> "ifm_payacceptancebill".equals(o.getDataEntity().getString("sourcebilltype"))).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(bizBillIds)) {
            lockedIds = TxCheckUtil.loadUnfinishedTx(bizBillIds);
        }
        Map<Long, String> checkMAmp = this.checkPushCdmBill(this.dataEntities);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject transBill = dataEntity.getDataEntity();
            String transType = transBill.getString("transtype");
            String paidStatus = transBill.getString("paidstatus");
            if (!TransBillPaidStatusEnum.isPaid((String)paidStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u80fd\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransHandleBillCancelPayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (!TransTypeEnum.isInnerPayType((String)transType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u975e\u5185\u90e8\u4ee3\u4ed8\u3001\u5185\u90e8\u8f6c\u8d26\u3001\u5185\u90e8\u6263\u6b3e\u6216\u8054\u52a8\u652f\u4ed8\uff0c\u9700\u8981\u4ece\u4e0a\u6e38\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransHandleBillCancelPayValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (transBill.getBoolean("iscommitbe")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u4e0d\u80fd\u76f4\u63a5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransHandleBillCancelPayValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            String cdmBillno = checkMAmp.get(transBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((String)cdmBillno)) {
                this.addErrorMessage(dataEntity, IfmBusResourceEnum.TransHandleBillCancelPayValidator_5.loadKDString(cdmBillno));
                continue;
            }
            if (lockedIds.contains(transBill.getString("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u540c\u6b65\u4ed8\u6b3e\u5904\u7406\u5355\u72b6\u6001\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\u6267\u884c\u5931\u8d25\u6216\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TransHandleBillCancelPayValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (JournalBookHelper.isBookJournalType((String)transType)) {
                billIdsForCheckJournal.add(transBill.getLong("id"));
            }
            checkVcIds.add(transBill.getLong("id"));
            if (!this.checkAutoDowntoBankstate(transBill)) continue;
            bankmentIds.add(transBill.getLong("id"));
        }
        if (!billIdsForCheckJournal.isEmpty()) {
            this.checkJournal(idEntityMap, "ifm_transhandlebill", billIdsForCheckJournal);
        }
        if (!checkVcIds.isEmpty()) {
            this.checkVoucher(idEntityMap, "ifm_transhandlebill", checkVcIds);
            this.checkTransdetail(idEntityMap, "ifm_transhandlebill", checkVcIds, bankmentIds);
        }
        this.checkPayBillJournal(idEntityMap, checkVcIds);
        this.checkSettleCenterAcceptDate(idEntityMap, "ifm_transhandlebill", checkVcIds);
    }

    private Map<Long, String> checkPushCdmBill(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> checkIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject settleType;
            DynamicObject transBill = dataEntity.getDataEntity();
            if (!TransTypeEnum.isAgentPay((Object)transBill.getString("transtype")) || (settleType = transBill.getDynamicObject("settletype")) == null || !SettleMentTypeEnum.isBankOrBusiness((String)settleType.getString("settlementtype"))) continue;
            checkIds.add(transBill.getLong("id"));
        }
        if (checkIds.size() > 0) {
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cdm_payablebill", (String)"sourcebillid,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", checkIds).and("billstatus", "!=", (Object)"H")});
            return payBills.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillid"), o -> o.getString("billno"), (v1, v2) -> v2));
        }
        return new HashMap<Long, String>();
    }

    private boolean checkAutoDowntoBankstate(DynamicObject transBill) {
        DynamicObject bankAccount;
        String transType = transBill.getString("transtype");
        if (TransTypeEnum.isLinkagePAY((Object)transType) && (bankAccount = transBill.getDynamicObject("bankaccount")) != null) {
            bankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccount.getPkValue(), (String)"bd_accountbanks", (String)"company");
            DynamicObject company = bankAccount.getDynamicObject("company");
            if (bankAccount != null && company != null) {
                boolean isBookIfm = TransBillHelper.isBookIfm((long)company.getLong("id"));
                boolean isBookInner = TransBillHelper.isBookInner((long)company.getLong("id"));
                if (!isBookIfm && !isBookInner) {
                    return true;
                }
            }
        }
        return false;
    }

    private void checkPayBillJournal(Map<Long, ExtendedDataEntity> idEntityMap, List<Long> billIds) {
        Object[] acceptBills;
        ArrayList<Long> acceptBillIds = new ArrayList<Long>(10);
        HashMap<Long, Long> acceptBillId2TransBillId = new HashMap<Long, Long>(10);
        HashMap<Long, Long> casPayBillId2AcceptBillIds = new HashMap<Long, Long>(10);
        for (Long l : billIds) {
            ExtendedDataEntity extendEntity = idEntityMap.get(l);
            DynamicObject transBill = extendEntity.getDataEntity();
            if (!"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) continue;
            Long acceptBillId = transBill.getLong("sourcebillid");
            acceptBillIds.add(acceptBillId);
            acceptBillId2TransBillId.put(acceptBillId, transBill.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(acceptBillIds) && EmptyUtil.isNoEmpty((Object[])(acceptBills = TmcDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"id,sourcebillid, sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", acceptBillIds)})))) {
            Long acceptBillId;
            for (Object acceptBill : acceptBills) {
                acceptBillId = acceptBill.getLong("id");
                Long payBillId = acceptBill.getLong("sourcebillid");
                casPayBillId2AcceptBillIds.putIfAbsent(payBillId, acceptBillId);
            }
            ArrayList arrayList = new ArrayList(casPayBillId2AcceptBillIds.keySet());
            Map invalidMap = JournalBookHelper.validateBeforeCancel((String)"cas_paybill", arrayList);
            for (Map.Entry entry : invalidMap.entrySet()) {
                acceptBillId = (Long)casPayBillId2AcceptBillIds.get(entry.getKey());
                Long transBillId = (Long)acceptBillId2TransBillId.get(acceptBillId);
                if (EmptyUtil.isEmpty((Long)transBillId)) continue;
                this.addErrorMessage(idEntityMap.get(transBillId), (String)entry.getValue());
            }
        }
    }
}

