/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransHandleBillCancelRefundValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] datas) throws KDBizException {
        Set billIDs = Arrays.stream(datas).map(dy -> dy.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection strategySets = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id,recbill", (QFilter[])new QFilter[]{new QFilter("id", "in", billIDs)});
        HashMap idToStatusMap = new HashMap();
        strategySets.stream().forEach(dy -> idToStatusMap.put(dy.getLong("id"), dy.getString("recbill")));
        for (ExtendedDataEntity data : datas) {
            DynamicObject transBill = data.getDataEntity();
            if (!EmptyUtil.isEmpty((String)((String)idToStatusMap.get(transBill.getLong("id"))))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u53d6\u6d88\u9000\u6b3e\u9000\u7968!", (String)"TransHandleBillCancelRefundValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

