/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.resources.IfmBusResourceEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;

public class TransHandleBillPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("iscommitbe");
        selector.add("billstatus");
        selector.add("paidstatus");
        selector.add("usage");
        selector.add("payeename");
        selector.add("recaccbankname");
        selector.add("payeebanknum");
        selector.add("recprovince");
        selector.add("reccountry");
        selector.add("reccity");
        selector.add("agentpayeraccount");
        selector.add("paymentchannel");
        selector.add("paymentidentify");
        selector.add("currency");
        selector.add("actpayamt");
        selector.add("settletype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set agentPayerAccountSet = Arrays.stream(this.dataEntities).filter(d -> d.getDataEntity().getDynamicObject("agentpayeraccount") != null).map(d -> d.getDataEntity().getDynamicObject("agentpayeraccount").getPkValue()).collect(Collectors.toSet());
        Map<Object, Object> accountStatusMap = new HashMap(this.dataEntities.length);
        if (!agentPayerAccountSet.isEmpty()) {
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "in", agentPayerAccountSet).toArray());
            accountStatusMap = accounts.stream().collect(Collectors.toMap(e -> e.get("id"), e -> e.getString("acctstatus")));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject settleType;
            DynamicObject info = dataEntity.getDataEntity();
            String transType = (String)info.get("transtype");
            DynamicObject dt = QueryServiceHelper.queryOne((String)"ifm_transhandlebill", (String)"paidstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", info.getPkValue())});
            String paidStatus = dt.getString("paidstatus");
            if (!TransTypeEnum.isAgentPay((Object)transType) && !TransTypeEnum.isLinkagePAY((Object)transType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5185\u90e8\u4ee3\u4ed8\u6216\u8054\u52a8\u652f\u4ed8\u7684\u5355\u636e\u624d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransHandleBillPayValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (!TransBillPaidStatusEnum.WAITING.getValue().equals(paidStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransHandleBillPayValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject paymentIdenty = info.getDynamicObject("paymentidentify");
            if (EmptyUtil.isNoEmpty((DynamicObject)paymentIdenty) && "1".equals(paymentIdenty.getString("type"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6807\u8bc6\u4e3a\u88ab\u52a8\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransHandleBillPayValidator_9", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject agentPayerAccount = info.getDynamicObject("agentpayeraccount");
            String paymentChannel = info.getString("paymentchannel");
            if (!PaymentChanEnum.BEI.getValue().equals(paymentChannel) || !agentPayerAccount.getBoolean("issetbankinterface")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u5f00\u901a\u94f6\u884c\u63a5\u53e3\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u624d\u80fd\u63d0\u4ea4\u94f6\u4f01\uff01", (String)"TransHandleBillPayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (BankAcctStatusEnum.CLOSED.getValue().equals(accountStatusMap.get(agentPayerAccount.getPkValue()))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%1$s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"TransHandleBillPayValidator_12", (String)"tmc-ifm-business", (Object[])new Object[0]), agentPayerAccount.getString("number")));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(settleType = info.getDynamicObject("settletype"))) && (SettleMentTypeEnum.isBankOrBusiness((String)settleType.getString("settlementtype")) || SettleMentTypeEnum.isPromissory((String)settleType.getString("settlementtype")) || SettleMentTypeEnum.isCheck((String)settleType.getString("settlementtype")))) {
                this.addErrorMessage(dataEntity, IfmBusResourceEnum.TransHandleBillPayValidator_11.loadKDString());
            }
            if (EmptyUtil.isEmpty((String)info.getString("usage"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u9644\u8a00\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01\u76f4\u8fde\u3002", (String)"TransHandleBillPayValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)info.getString("payeename"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransHandleBillPayValidator_10", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)info.getString("recaccbankname"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"TransHandleBillPayValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)info.getString("payeebanknum"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"TransHandleBillPayValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)info.getString("recprovince"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u7701\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"TransHandleBillPayValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)info.getString("reccity"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5e02\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"TransHandleBillPayValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isEmpty((String)info.getString("reccountry"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01", (String)"TransHandleBillPayValidator_8", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

