/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.ifm.business.validator.transhandlebill.AbstractTransBillCancelPayValidator;
import kd.tmc.ifm.helper.JournalBookHelper;

public class TransHandleBillRevokeValidator
extends AbstractTransBillCancelPayValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("iscommitbe");
        selector.add("transtype");
        selector.add("matchflag");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<Long, ExtendedDataEntity> idEntityMap = this.toIdEntityMap(extendedDataEntities);
        ArrayList<Long> billIdsForCheckJournal = new ArrayList<Long>(extendedDataEntities.length);
        ArrayList<Long> checkVcIds = new ArrayList<Long>(extendedDataEntities.length);
        List billIds = Arrays.stream(extendedDataEntities).map(o -> String.valueOf(o.getDataEntity().getLong("id"))).collect(Collectors.toList());
        List lockedIds = new ArrayList();
        if (billIds != null && billIds.size() > 0) {
            lockedIds = TxCheckUtil.loadUnfinishedTx(billIds);
        }
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject transBill = dataEntity.getDataEntity();
            if (transBill.getBoolean("iscommitbe")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u4e0d\u80fd\u76f4\u63a5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransHandleBillCancelPayValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (!MatchStatusEnum.UNSMARTMATCH.getValue().equals(transBill.getString("matchflag"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u5148\u53d6\u6d88\u5339\u914d\u3002", (String)"TransHandleBillCancelPayValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            String transType = transBill.getString("transtype");
            if (JournalBookHelper.isBookJournalType((String)transType)) {
                billIdsForCheckJournal.add(transBill.getLong("id"));
            }
            checkVcIds.add(transBill.getLong("id"));
            if (!lockedIds.contains(String.valueOf(transBill.getLong("id")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"TransHandleBillBackValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (!billIdsForCheckJournal.isEmpty()) {
            this.checkJournal(idEntityMap, "ifm_transhandlebill", billIdsForCheckJournal);
        }
        if (!checkVcIds.isEmpty()) {
            this.checkVoucher(idEntityMap, "ifm_transhandlebill", checkVcIds);
            this.checkTransdetail(idEntityMap, "ifm_transhandlebill", checkVcIds, null);
            this.checkSettleCenterAcceptDate(idEntityMap, "ifm_transhandlebill", checkVcIds);
        }
    }
}

