/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.resources.IfmBusResourceEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.TransBillHelper;

public class TransHandleBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("payeeacctbank");
        selector.add("payeracctbank");
        selector.add("currency");
        selector.add("actpayamt");
        selector.add("unmatchamountpay");
        selector.add("matchamountpay");
        selector.add("matchflag");
        selector.add("payeename");
        selector.add("paymentidentify");
        selector.add("bankcheckflag");
        selector.add("beibankcheckflag");
        selector.add("sourcebillid");
        selector.add("sourcebillentryid");
        selector.add("sourcebilltype");
        selector.add("paidstatus");
        selector.add("recaccbankname");
        selector.add("payeebanknum");
        selector.add("paymentchannel");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObjectCollection payeeAccCcys;
            Long payeeAccountId;
            DynamicObject billDO = dataEntity.getDataEntity();
            QFilter filter = new QFilter("sourcebillid", "=", (Object)billDO.getLong("sourcebillid")).and(new QFilter("sourcebillentryid", "=", (Object)billDO.getLong("sourcebillentryid"))).and(new QFilter("id", "!=", billDO.getPkValue())).and(new QFilter("paidstatus", "not in", Arrays.asList(TransBillPaidStatusEnum.REFUSED.getValue(), TransBillPaidStatusEnum.RETURNTICKET.getValue())));
            boolean isExist = QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])new QFilter[]{filter});
            if (isExist) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u5df2\u751f\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TransHandleBillSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal actPayamt = billDO.getBigDecimal("actpayamt");
            if (EmptyUtil.isEmpty((BigDecimal)actPayamt)) {
                this.addErrorMessage(dataEntity, IfmBusResourceEnum.TransHandleBillSaveValidator_6.loadKDString());
                continue;
            }
            String checkMsg = TransBillHelper.checkCurrencyAmt((DynamicObject)billDO);
            if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                this.addErrorMessage(dataEntity, checkMsg);
                continue;
            }
            DynamicObject accDO = billDO.getDynamicObject("payeracctbank");
            if (accDO == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"TransHandleBillSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection accCcys = accDO.getDynamicObjectCollection("currency");
            DynamicObject currencyDO = billDO.getDynamicObject("currency");
            if (currencyDO == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"TransHandleBillSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            if (accDO != null && !accCcys.stream().anyMatch(o -> o.getDynamicObject("fbasedataid").getPkValue().equals(currencyDO.getPkValue()))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u5e01\u79cd\u548c\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u4e00\u81f4", (String)"TransHandleBillSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Long)(payeeAccountId = Long.valueOf(billDO.get("payeeacctbank") == null ? 0L : Long.parseLong(billDO.get("payeeacctbank").toString()))))) continue;
            DynamicObject payeeAcct = null;
            QFilter qFilter = new QFilter("id", "=", (Object)payeeAccountId);
            DynamicObjectCollection payeeAccts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,currency,inneracct", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)payeeAccts) || !EmptyUtil.isNoEmpty((Object)(payeeAcct = (DynamicObject)payeeAccts.get(0)).get("inneracct")) || (payeeAccCcys = accDO.getDynamicObjectCollection("currency")).stream().anyMatch(o -> o.getDynamicObject("fbasedataid").getPkValue().equals(currencyDO.getPkValue()))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u5e01\u79cd\u548c\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u4e00\u81f4", (String)"TransHandleBillSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

