/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.helper.TransBillBusHelper;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;

public class TransHandleBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("agentfinorgcat");
        selector.add("agentpayeraccount");
        selector.add("agentpayeraccname");
        selector.add("agentfinorg");
        selector.add("billstatus");
        selector.add("paidstatus");
        selector.add("payeeacctbank");
        selector.add("payeracctbank");
        selector.add("currency");
        selector.add("sourcebilltype");
        selector.add("actpayamt");
        selector.add("unmatchamountpay");
        selector.add("matchamountpay");
        selector.add("matchflag");
        selector.add("unmatchamountpay");
        selector.add("matchamountpay");
        selector.add("matchflag");
        selector.add("bankaccount");
        selector.add("sourcebillid");
        selector.add("sourcebillentryid");
        selector.add("recaccbankname");
        selector.add("payeebanknum");
        selector.add("paymentidentify");
        selector.add("payeename");
        selector.add("paymentchannel");
        selector.add("iscrosspay");
        selector.add("feepayer");
        selector.add("feeactbank");
        selector.add("feecurrency");
        selector.add("singlestream");
        selector.add("fee");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String res;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String transType = dataEntity.getString("transtype");
            String bizStatus = dataEntity.getString("paidstatus");
            if (bizStatus.equals(PayAcceptBizStatusEnum.REFUSED.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TransHandleBillSubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (TransTypeEnum.isAgentPay((Object)transType)) {
                if (this.checkAgentAccount(dataEntity)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u5185\u90e8\u4ee3\u4ed8\u65f6\uff0c\u4ee3\u7406\u652f\u4ed8\u4fe1\u606f\u5fc5\u586b\u3002", (String)"TransHandleBillSubmitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            } else if (TransTypeEnum.isLinkagePAY((Object)transType)) {
                DynamicObject bankAccount;
                if (this.checkAgentAccount(dataEntity)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u7ed3\u7b97\u4e2d\u5fc3\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5fc5\u586b\u3002", (String)"TransHandleBillSubmitValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((DynamicObject)(bankAccount = dataEntity.getDynamicObject("bankaccount")))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u6210\u5458\u5355\u4f4d\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5fc5\u586b\u3002", (String)"TransHandleBillSubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            if (!EmptyUtil.isNoEmpty((String)(res = TransBillBusHelper.checkFeeInfo(extendedDataEntity)))) continue;
            this.addErrorMessage(extendedDataEntity, res);
        }
    }

    private boolean checkAgentAccount(DynamicObject dataEntity) {
        DynamicObject agentFinOrg = dataEntity.getDynamicObject("agentfinorg");
        DynamicObject agentPayerAccount = dataEntity.getDynamicObject("agentpayeraccount");
        return EmptyUtil.isAnyoneEmpty((Object[])new Object[]{agentFinOrg, agentPayerAccount});
    }
}

