/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.ifm.report.helper.BalanceReportFilterParamHelper;
import kd.tmc.ifm.report.helper.ReportHelper;

public class AccountBalanceDataListPlugin
extends AbstractTmcListDataPlugin {
    private static final String SELECT_FIELDS = "id,accountbank.id,currency.id currencyid,lstbalance,amount,bizdate";

    public DataSet query(ReportQueryParam param, Object info) throws Throwable {
        Map<String, Object> paramMap = this.transQueryParam(param);
        Long currencyId = (Long)paramMap.get("filter_currency");
        DataSet accountDataSet = this.queryBankAccounts(paramMap);
        List<Long> innerAcctIds = this.getInnerIds(accountDataSet);
        if (innerAcctIds.size() == 0) {
            return ReportHelper.getEmptyDs();
        }
        DataSet balanceLastDataSet = this.getBalanceByDate(paramMap, innerAcctIds);
        DataSet resultDataSet = accountDataSet.leftJoin(balanceLastDataSet).on("id", "accountbankid").on("currencyid", "currencyid").select(new String[]{"id accountbankid", "currencyid", "companyid", "settlementcenter", "company", "accountname", "account", "accttype", "acctprop", "acctpurpose"}, new String[]{"amount yest_original"}).finish().updateField("yest_original", "case when yest_original is null then 0 else yest_original end");
        DataSet transGroupDataSet = this.queryTransDetailDs(innerAcctIds, paramMap);
        resultDataSet = resultDataSet.leftJoin(transGroupDataSet).on("accountbankid", "accountbankid").on("currencyid", "currencyid").select(new String[]{"currencyid", "companyid", "settlementcenter", "company", "accountname", "account", "accttype", "acctprop", "acctpurpose", "yest_original", "case when creditamount is null then 0 else creditamount end income_original", "case when debitamount is null then 0 else debitamount end expend_original", "0 balan_original"}).finish().updateField("balan_original", "yest_original+income_original-expend_original");
        resultDataSet = this.getDsFromRateAndUnit(resultDataSet, paramMap).updateField("balan_original", "case when balan_original is null then 0 else balan_original end").addField("currencyid", "originalcurrency").addField(String.valueOf(currencyId), "reportcurrency");
        DataSet subTotalDs = this.addSubTotalDataSet(resultDataSet, Arrays.asList("company", "reportcurrency"), this.getSumField(), "accountname");
        DataSet totalDs = this.addAllTotalDataSet(resultDataSet, this.getSumField(), Collections.singletonList("reportcurrency"), "company");
        DataSet result = resultDataSet.union(subTotalDs).orderBy(new String[]{"company", "sumlevel"});
        return result.union(totalDs);
    }

    private DataSet getDsFromRateAndUnit(DataSet resultDataSet, Map<String, Object> paramMap) {
        Long currencyId = (Long)paramMap.get("filter_currency");
        Long exTableId = (Long)paramMap.get("exchageTableId");
        String unit = ReportHelper.getUnit((String)paramMap.get("filter_currencyunit"));
        DataSet exRateByTableDataSet = this.getExRateByTableDataSet(resultDataSet, currencyId, exTableId, DateUtils.getCurrentDate()).addField(unit, "unit");
        DataSet resultDs = resultDataSet.leftJoin(exRateByTableDataSet).on("currencyid", "currencyid").select(new String[]{"currencyid", "companyid", "settlementcenter", "company", "accountname", "account", "accttype", "acctprop", "acctpurpose", "yest_original/unit yest_original", "yest_original*exchgRate/unit yest_report", "income_original/unit income_original", "income_original*exchgRate/unit income_report", "expend_original/unit expend_original", "expend_original*exchgRate/unit expend_report", "balan_original/unit balan_original", "balan_original*exchgRate/unit balan_report", "0 sumlevel"}).finish();
        return resultDs;
    }

    private DataSet getBalanceByDate(Map<String, Object> paramMap, List<Long> innerAcctIds) {
        Date filterDate = (Date)paramMap.get("filter_begindate");
        QFilter filter = new QFilter("accountbank.id", "in", innerAcctIds).and(new QFilter("bizdate", "<", (Object)DateUtils.getDataFormat((Date)filterDate, (boolean)true)));
        DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("filter_orgcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
            filter.and(new QFilter("currency.id", "in", (Object)currencys.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{filter}, null);
        DataSet beginLastBalanceDs = this.getLastBalanceDs(balanceDataSet).select(new String[]{"accountbankid", "currencyid", "amount"});
        return beginLastBalanceDs;
    }

    private DataSet getLastBalanceDs(DataSet balanceDataSet) {
        DataSet balanceLastGroup = balanceDataSet.groupBy(new String[]{"accountbank.id", "currencyid"}).max("bizdate").finish();
        DataSet balanceLastDataSet = balanceLastGroup.join(balanceDataSet, JoinType.LEFT).on("accountbank.id", "accountbank.id").on("currencyid", "currencyid").on("bizdate", "bizdate").select(new String[]{"id", "accountbank.id accountbankid", "currencyid", "amount", "bizdate"}).finish();
        return balanceLastDataSet;
    }

    private DataSet queryBankAccounts(Map<String, Object> paramMap) {
        QFilter[] innerAccountFilters = BalanceReportFilterParamHelper.buildAccountFilter(paramMap);
        DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountbanks", (String)"id,bank.name settlementcenter,company.id companyid,company.name company,name accountname,bankaccountnumber account,acctstyle accttype,accttype acctprop,acctproperty.name acctpurpose,currency.fbasedataid currencyid", (QFilter[])innerAccountFilters, null);
        return accountDataSet;
    }

    private List<Long> getInnerIds(DataSet accountDataSet) {
        ArrayList<Long> innerAcctIds = new ArrayList<Long>(10);
        for (Row idRow : accountDataSet.copy()) {
            innerAcctIds.add(idRow.getLong("id"));
        }
        return innerAcctIds;
    }

    private DataSet queryTransDetailDs(List<Long> innerAcctIds, Map<String, Object> paramMap) {
        QFilter qFilter = new QFilter("accountbank.id", "in", innerAcctIds);
        DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("filter_orgcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencys)) {
            qFilter.and("currency.id", "in", (Object)currencys.stream().map(DataEntityBase::getPkValue).toArray());
        }
        Date beginDate = (Date)paramMap.get("filter_begindate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        qFilter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)beginDate, (boolean)true)));
        qFilter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        String transSelectFields = "id,accountbank.id accountbankid ,currency.id currencyid,debitamount,creditamount";
        DataSet transDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_transdetail", (String)transSelectFields, (QFilter[])qFilter.toArray(), null);
        DataSet transGroupDataSet = transDataSet.groupBy(new String[]{"accountbankid", "currencyid"}).sum("debitamount").sum("creditamount").finish();
        return transGroupDataSet;
    }

    protected DataSet getExRateByTableDataSet(DataSet sourceDataSet, Long currencyID, Long exchangeRateTableId, Date bizDate) {
        ArrayList<Object[]> cnyList = new ArrayList<Object[]>();
        HashSet<Long> currencySet = new HashSet<Long>();
        for (Row row : sourceDataSet.copy()) {
            BigDecimal exchangeRate;
            Long sCurrencyId = row.getLong("currencyid");
            if (!currencySet.add(sCurrencyId)) continue;
            Object[] obj = null;
            if (null != sCurrencyId && null != currencyID && sCurrencyId.equals(currencyID)) {
                obj = new Object[]{sCurrencyId, 1};
            }
            obj = (exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sCurrencyId, (Long)currencyID, (Date)bizDate)) == null ? new Object[]{sCurrencyId, 1} : new Object[]{sCurrencyId, exchangeRate};
            cnyList.add(obj);
        }
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("currencyid", (DataType)DataType.LongType));
        field.add(new Field("exchgRate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSet exChgRateDataSet = algo.createDataSet(cnyList, rowMeta);
        return exChgRateDataSet;
    }

    protected Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    private List<String> getSumField() {
        return Arrays.asList("yest_report", "income_report", "expend_report", "balan_report");
    }
}

