/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.enums.DateTypeEnum;

public class AvgBalanceDataListPlugin
extends AbstractTmcListDataPlugin {
    private static Log logger = LogFactory.getLog(AvgBalanceDataListPlugin.class);
    private List<String> dynamicColList = new ArrayList<String>(){
        {
            this.add("settlementcenter");
            this.add("company");
            this.add("account");
            this.add("accountname");
            this.add("acctpurpose");
            this.add("currency");
            this.add("avgbalance");
        }
    };
    private DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.BigDecimalType};
    List<String> monthCol = new ArrayList<String>(10);
    List<String> seasonCol = new ArrayList<String>(10);

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List filterItems = this.getQueryParam().getFilter().getFilterItems();
        String type = "";
        for (FilterItemInfo filterItem : filterItems) {
            if (!"filter_type".equals(filterItem.getPropName())) continue;
            type = (String)filterItem.getValue();
            break;
        }
        this.createColumsbyType(columns, type);
        return columns;
    }

    private void createColumsbyType(List<AbstractReportColumn> columns, String type) {
        if (DateTypeEnum.DAY.getValue().equals(type)) {
            this.getDynamicColByDay(columns);
        } else if (DateTypeEnum.MONTH.getValue().equals(type)) {
            this.getDynamicColByMonth(columns);
        } else if (DateTypeEnum.SEASON.getValue().equals(type)) {
            this.getDynamicColBySeason(columns);
        } else {
            this.getDynamicColByYear(columns);
        }
    }

    public DataSet query(ReportQueryParam param, Object info) throws Throwable {
        Map paramMap = this.transQueryParam(param);
        DynamicObjectCollection bankAccount = (DynamicObjectCollection)paramMap.get("filter_bankaccount");
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        String type = (String)paramMap.get("filter_type");
        SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDatestr = sdfs.format(startDate);
        String endDatestr = sdfs.format(endDate);
        int startYear = Integer.parseInt(startDatestr.substring(0, 4));
        int endYear = Integer.parseInt(endDatestr.substring(0, 4));
        if (DateTypeEnum.MONTH.getValue().equals(type)) {
            List<String> months = this.getMonthBetweenDate(startDatestr, endDatestr);
            for (String month : months) {
                String yearStr = month.substring(0, 4);
                String monthStr = month.substring(5);
                if (!"10".equals(monthStr)) {
                    monthStr = monthStr.replace("0", "");
                }
                this.monthCol.add("m" + yearStr + monthStr);
            }
        } else if (DateTypeEnum.SEASON.getValue().equals(type)) {
            String startSeason = (String)paramMap.get("filter_startseason");
            String endSeason = (String)paramMap.get("filter_endseason");
            startDate = this.getFirstDateByYearSeason(startYear, Integer.parseInt(startSeason));
            Date tempDate = this.getFirstDateByYearSeason(endYear, Integer.parseInt(endSeason));
            endDate = DateUtils.getLastSeasonDate((Date)tempDate);
            LocalDate sdate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate edate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            this.seasonCol = this.getSeasonList(sdate, edate);
        } else if (DateTypeEnum.YEAR.getValue().equals(type)) {
            for (int i = 0; i < endYear - startYear + 1; ++i) {
                this.monthCol.add("m" + (startYear + i));
            }
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)paramMap.get("filter_currency");
        ArrayList<QFilter> balQFilterList = new ArrayList<QFilter>();
        balQFilterList.add(new QFilter("bizdate", ">=", (Object)this.getStartDate(startDate, type)));
        balQFilterList.add(new QFilter("bizdate", "<=", (Object)this.getEndDate(endDate, type)));
        if (!CollectionUtils.isEmpty((Collection)bankAccount)) {
            balQFilterList.add(new QFilter("accountbank.id", "in", (Object)bankAccount.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        Object[] ccys = null;
        if (!CollectionUtils.isEmpty((Collection)currency)) {
            ccys = currency.stream().map(DataEntityBase::getPkValue).toArray();
            balQFilterList.add(new QFilter("currency.id", "in", (Object)ccys));
        }
        QFilter[] innerAccountFilters = AvgBalanceDataListPlugin.buildAccountFilter(paramMap);
        DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountbanks", (String)"id,bank.name settlementcenter,company.id company,acctproperty.id acctpurpose", (QFilter[])innerAccountFilters, null);
        ArrayList<Long> innerAcctIds = new ArrayList<Long>(10);
        for (Row idRow : accountDataSet.copy()) {
            innerAcctIds.add(idRow.getLong("id"));
        }
        if (innerAcctIds.size() == 0) {
            RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        }
        balQFilterList.add(new QFilter("accountbank.id", "in", innerAcctIds));
        String selectFields = "id,accountbank.id,currency.id,amount,bizdate";
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)selectFields, (QFilter[])balQFilterList.toArray(new QFilter[0]), null);
        DataSet reslut = this.resultDataSetByType(balanceDataSet, accountDataSet, type);
        if (reslut == null || reslut.isEmpty() || !reslut.hasNext()) {
            RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        }
        return reslut;
    }

    private DataSet resultDataSetByType(DataSet balanceDataSet, DataSet accountDataSet, String type) {
        if (DateTypeEnum.DAY.getValue().equals(type)) {
            return this.getAvgDataSetByDay(balanceDataSet, accountDataSet);
        }
        if (DateTypeEnum.MONTH.getValue().equals(type)) {
            return this.getAvgDataSetByMonth(balanceDataSet, accountDataSet);
        }
        if (DateTypeEnum.SEASON.getValue().equals(type)) {
            return this.getAvgDataSetBySeason(balanceDataSet, accountDataSet);
        }
        if (DateTypeEnum.YEAR.getValue().equals(type)) {
            return this.getAvgDataSetByYear(balanceDataSet, accountDataSet);
        }
        return null;
    }

    private DataSet getAvgDataSetByDay(DataSet balanceDataSet, DataSet accountDataSet) {
        DataSet balanceDataGroup = balanceDataSet.groupBy(new String[]{"accountbank.id", "currency.id"}).avg("amount", "avgbalance").finish();
        DataSet resultDataSet = balanceDataGroup.join(accountDataSet, JoinType.INNER).on("accountbank.id", "id").select(new String[]{"settlementcenter", "company", "id account", "id accountname", "acctpurpose", "currency.id currency", "avgbalance"}).finish().addField("0", "sumlevel");
        Iterator iterator = resultDataSet.copy().iterator();
        HashSet<Long> currencySet = new HashSet<Long>(1);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            currencySet.add(row.getLong("currency"));
        }
        if (currencySet.size() == 1) {
            DataSet sumAllDs = this.addAllTotalDataSet(resultDataSet, Collections.singletonList("avgbalance"), Collections.singletonList("currency"), "settlementcenter");
            return resultDataSet.union(sumAllDs);
        }
        return resultDataSet;
    }

    private DataSet getAvgDataSetByMonth(DataSet balanceDataSet, DataSet accountDataSet) {
        DataSet avgbyMonth = balanceDataSet.addField("Year(bizdate)", "year").addField("Month(bizdate)", "month");
        DataSet avgbyMonthGroup = avgbyMonth.groupBy(new String[]{"accountbank.id", "currency.id", "year", "month"}).avg("amount", "avgbalance").finish();
        DataSet resultDataSet = avgbyMonthGroup.join(accountDataSet, JoinType.INNER).on("accountbank.id", "id").select(new String[]{"settlementcenter", "company", "id account", "id accountname", "acctpurpose", "currency.id currency", "year", "month", "avgbalance"}).finish();
        this.dynamicColList.addAll(this.monthCol);
        DataSet result = this.getRowToColDataSet(resultDataSet, this.dynamicColList, this.monthCol, "month").addField("0", "sumlevel");
        Iterator iterator = resultDataSet.copy().iterator();
        HashSet<Long> currencySet = new HashSet<Long>(1);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            currencySet.add(row.getLong("currency"));
        }
        if (currencySet.size() == 1) {
            DataSet sumAllDs = this.addAllTotalDataSet(result, this.monthCol, Collections.singletonList("currency"), "settlementcenter");
            return result.union(sumAllDs);
        }
        return result;
    }

    private DataSet getAvgDataSetBySeason(DataSet balanceDataSet, DataSet accountDataSet) {
        DataSet avgbySeason = balanceDataSet.addField("Year(bizdate)", "year").addField("Month(bizdate)", "month").addField("case when month >=1 and month <= 3 then '1' when month >=4 and month <= 6 then '2' when month >= 7 and month <= 9 then '3' else '4' end", "season");
        DataSet avgbySeasonGroup = avgbySeason.groupBy(new String[]{"accountbank.id", "currency.id", "year", "season"}).avg("amount", "avgbalance").finish();
        DataSet resultDataSet = avgbySeasonGroup.join(accountDataSet, JoinType.INNER).on("accountbank.id", "id").select(new String[]{"settlementcenter", "company", "id account", "id accountname", "acctpurpose", "currency.id currency", "year", "season", "avgbalance"}).finish();
        this.dynamicColList.addAll(this.seasonCol);
        DataSet result = this.getRowToColDataSet(resultDataSet, this.dynamicColList, this.seasonCol, "season").addField("0", "sumlevel");
        Iterator iterator = resultDataSet.copy().iterator();
        HashSet<Long> currencySet = new HashSet<Long>(1);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            currencySet.add(row.getLong("currency"));
        }
        if (currencySet.size() == 1) {
            DataSet sumAllDs = this.addAllTotalDataSet(result, this.seasonCol, Collections.singletonList("currency"), "settlementcenter");
            return result.union(sumAllDs);
        }
        return result;
    }

    private DataSet getAvgDataSetByYear(DataSet balanceDataSet, DataSet accountDataSet) {
        DataSet avgbyYear = balanceDataSet.addField("Year(bizdate)", "year").addField("Month(bizdate)", "month");
        DataSet avgbyYearGroup = avgbyYear.groupBy(new String[]{"accountbank.id", "currency.id", "year"}).avg("amount", "avgbalance").finish();
        DataSet resultDataSet = avgbyYearGroup.join(accountDataSet, JoinType.INNER).on("accountbank.id", "id").select(new String[]{"settlementcenter", "company", "id account", "id accountname", "acctpurpose", "currency.id currency", "year", "avgbalance"}).finish();
        this.dynamicColList.addAll(this.monthCol);
        DataSet result = this.getRowToColDataSet(resultDataSet, this.dynamicColList, this.monthCol, "year").addField("0", "sumlevel");
        Iterator iterator = resultDataSet.copy().iterator();
        HashSet<Long> currencySet = new HashSet<Long>(1);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            currencySet.add(row.getLong("currency"));
        }
        if (currencySet.size() == 1) {
            DataSet sumAllDs = this.addAllTotalDataSet(result, this.monthCol, Collections.singletonList("currency"), "settlementcenter");
            return result.union(sumAllDs);
        }
        return result;
    }

    private Date getStartDate(Date startdate, String type) {
        if (DateTypeEnum.DAY.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)startdate, (boolean)Boolean.TRUE);
        }
        if (DateTypeEnum.MONTH.getValue().equals(type)) {
            return DateUtils.getFirstDayOfMonth((Date)startdate);
        }
        if (DateTypeEnum.SEASON.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)startdate, (boolean)Boolean.TRUE);
        }
        if (DateTypeEnum.YEAR.getValue().equals(type)) {
            return DateUtils.getFirstYearDate((Date)startdate);
        }
        return null;
    }

    private Date getEndDate(Date enddate, String type) {
        if (DateTypeEnum.DAY.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)enddate, (boolean)Boolean.FALSE);
        }
        if (DateTypeEnum.MONTH.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)DateUtils.getLastDayOfMonth((Date)enddate), (boolean)Boolean.FALSE);
        }
        if (DateTypeEnum.SEASON.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)enddate, (boolean)Boolean.FALSE);
        }
        if (DateTypeEnum.YEAR.getValue().equals(type)) {
            return DateUtils.getDataFormat((Date)DateUtils.getLastYearDate((Date)enddate), (boolean)Boolean.FALSE);
        }
        return null;
    }

    private DataSet getRowToColDataSet(DataSet resultDataSet, List<String> dynamicColList, List<String> monthCol, String type) {
        String[] FIELDS = dynamicColList.toArray(new String[dynamicColList.size()]);
        Object[] DATATYPES_MONTH = new DataType[monthCol.size()];
        for (int i = 0; i < monthCol.size(); ++i) {
            DATATYPES_MONTH[i] = DataType.BigDecimalType;
        }
        DataType[] DATATYPES_All = (DataType[])ArrayUtils.addAll((Object[])this.DATATYPES, (Object[])DATATYPES_MONTH);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        RowMeta createRowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES_All);
        CollectionInput collectionInput = new CollectionInput(createRowMeta, coll);
        DataSet createDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{collectionInput});
        String preAccount = null;
        String preCurrency = null;
        for (Row row : resultDataSet.copy()) {
            preAccount = row.getString("account");
            preCurrency = row.getString("currency");
            if (!EmptyUtil.isNoEmpty((String)preAccount) || !EmptyUtil.isNoEmpty((String)preCurrency)) continue;
            break;
        }
        Object[] tempData = new Object[FIELDS.length];
        coll.add(tempData);
        String tempAccount = null;
        String tempCurrency = null;
        block2: for (Row row : resultDataSet.copy()) {
            tempAccount = row.getString("account");
            tempCurrency = row.getString("currency");
            if (!StringUtils.equals((CharSequence)preAccount, (CharSequence)tempAccount) || !StringUtils.equals((CharSequence)preCurrency, (CharSequence)tempCurrency)) {
                tempData = new Object[FIELDS.length];
                coll.add(tempData);
                preAccount = tempAccount;
                preCurrency = tempCurrency;
            }
            String typeValue = "";
            if (Objects.nonNull(type) && !"year".equals(type)) {
                typeValue = row.getString(type);
            }
            for (int i = 0; i < FIELDS.length; ++i) {
                String dateStr = "m" + row.getString("year") + typeValue;
                if (i < 7) {
                    tempData[i] = row.getString(FIELDS[i]);
                    continue;
                }
                if (!FIELDS[i].equals(dateStr)) continue;
                tempData[i] = row.getString("avgbalance");
                continue block2;
            }
        }
        return createDataSet;
    }

    private Date getFirstDateByYearSeason(int year, int season) {
        Calendar ca = Calendar.getInstance();
        ca.set(1, year);
        ca.set(5, 1);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        if (season == 1) {
            ca.set(2, 0);
        } else if (season == 2) {
            ca.set(2, 3);
        } else if (season == 3) {
            ca.set(2, 6);
        } else if (season == 4) {
            ca.set(2, 9);
        }
        return ca.getTime();
    }

    private List<String> getSeasonList(LocalDate startTime, LocalDate endTime) {
        startTime = LocalDate.of(startTime.getYear(), startTime.getMonthValue(), 1);
        endTime = LocalDate.of(endTime.getYear(), endTime.getMonthValue(), 1);
        HashSet<String> set = new HashSet<String>(10);
        LocalDate mark = startTime;
        while (mark.isBefore(endTime) || mark.isEqual(endTime)) {
            String season = "m" + mark.getYear() + (mark.getMonthValue() + 2) / 3;
            set.add(season);
            mark = mark.plusMonths(1L);
        }
        return set.stream().sorted().collect(Collectors.toList());
    }

    private List<String> getMonthBetweenDate(String startTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<String> list = new ArrayList<String>(12);
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            while (startDate.getTime() <= endDate.getTime()) {
                list.add(sdf.format(startDate));
                startDate = DateUtils.getNextMonth((Date)startDate, (int)1);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        return list;
    }

    public static QFilter[] buildAccountFilter(Map<String, Object> paramMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()));
        Boolean isincludeclose = (Boolean)paramMap.get("filter_isincludeclose");
        DynamicObjectCollection bankAccount = (DynamicObjectCollection)paramMap.get("filter_bankaccount");
        DynamicObjectCollection acctUseAge = (DynamicObjectCollection)paramMap.get("filter_acctuseage");
        DynamicObjectCollection settlementCenter = (DynamicObjectCollection)paramMap.get("filter_settlementcenter");
        if (!isincludeclose.booleanValue()) {
            filterList.add(new QFilter("acctstatus", "not in", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
        if (!Objects.isNull(acctUseAge)) {
            filterList.add(new QFilter("inneracct.acctuseage", "in", acctUseAge.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList())));
        }
        if (!CollectionUtils.isEmpty((Collection)settlementCenter)) {
            filterList.add(new QFilter("inneracct.finorg", "in", settlementCenter.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList())));
        }
        if (!CollectionUtils.isEmpty((Collection)bankAccount)) {
            filterList.add(new QFilter("id", "in", (Object)bankAccount.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        return filterList.toArray(new QFilter[0]);
    }

    private void getDynamicColByDay(List<AbstractReportColumn> columns) {
        DecimalReportColumn column = new DecimalReportColumn();
        column.setCurrencyField("currency");
        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d", (String)"AvgBalanceDataListPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0])));
        column.setFieldKey("avgbalance");
        column.setWidth(new LocaleString("100px"));
        column.setFieldType("amount");
        column.setScale(10);
        column.setZeroShow(true);
        columns.add((AbstractReportColumn)column);
    }

    private void getDynamicColByMonth(List<AbstractReportColumn> columns) {
        for (String month : this.monthCol) {
            DecimalReportColumn column = new DecimalReportColumn();
            column.setCurrencyField("currency");
            column.setFieldKey(month);
            column.setWidth(new LocaleString("100px"));
            column.setFieldType("amount");
            column.setCurrencyField("currency");
            column.setScale(10);
            column.setZeroShow(true);
            String yearStr = month.substring(1, 5);
            String monthStr = month.substring(5);
            String str = ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d(%1$s)", (String)"AvgBalanceDataListPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]);
            String colName = String.format(str, yearStr + "-" + monthStr);
            column.setCaption(new LocaleString(colName));
            columns.add((AbstractReportColumn)column);
        }
    }

    private void getDynamicColBySeason(List<AbstractReportColumn> columns) {
        LinkedHashSet yearGroupSet = new LinkedHashSet(8);
        this.seasonCol.forEach(year -> yearGroupSet.add(year.substring(1, 5)));
        for (String yearStr : yearGroupSet) {
            String yearTrans = ResManager.loadKDString((String)"\u5e74", (String)"AvgBalanceReportFormListPlugin_5", (String)"tmc-ifm-report", (Object[])new Object[0]);
            String seasonTrans = ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"AvgBalanceReportFormListPlugin_6", (String)"tmc-ifm-report", (Object[])new Object[0]);
            ReportColumnGroup yearCol = new ReportColumnGroup();
            if (this.seasonCol.size() == 1) {
                yearCol.setCaption(new LocaleString(yearStr + yearTrans + this.seasonCol.get(0).substring(5) + seasonTrans));
            } else {
                yearCol.setCaption(new LocaleString(yearStr + yearTrans));
            }
            yearCol.setFieldKey(yearStr);
            for (String items : this.seasonCol) {
                String year2 = items.substring(1, 5);
                String season = items.substring(5);
                if (!year2.equals(yearStr)) continue;
                DecimalReportColumn column = new DecimalReportColumn();
                column.setFieldKey(items);
                column.setCaption(new LocaleString(season + seasonTrans));
                column.setWidth(new LocaleString("100px"));
                column.setFieldType("amount");
                column.setCurrencyField("currency");
                column.setScale(10);
                column.setZeroShow(true);
                yearCol.getChildren().add(column);
            }
            columns.add((AbstractReportColumn)yearCol);
        }
    }

    private void getDynamicColByYear(List<AbstractReportColumn> columns) {
        for (String month : this.monthCol) {
            DecimalReportColumn column = new DecimalReportColumn();
            column.setCurrencyField("currency");
            column.setFieldKey(month);
            column.setWidth(new LocaleString("100px"));
            column.setFieldType("amount");
            column.setScale(10);
            column.setZeroShow(true);
            String yearStr = month.substring(1, 5);
            String str = ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d(%1$s)\u5e74", (String)"AvgBalanceDataListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]);
            String colName = String.format(str, yearStr);
            column.setCaption(new LocaleString(colName));
            columns.add((AbstractReportColumn)column);
        }
    }
}

