/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.ifm.report.helper.ReportHelper;

public class InterestDetailListPlugin
extends AbstractTmcListDataPlugin {
    private Map<String, Object> paramMap = null;
    private static final String SELECT_FIELDS = "id," + "settlecenter.id as settlecenterid," + "settlecenter.name as settlecenter," + "intobject.id as intobjectid," + "intobject.name as intobject," + "inneracct.id as inneracctid," + "inneracct.company.name as company," + "inneracct.number as account," + "currency.id as currency," + "entry.inststartdate as startdate," + "entry.instenddate as enddate," + "entry.inttype as inttype," + "entry.instdays as instdays," + "entry.instprincipal as instprincipal," + "entry.instamount as instamount";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String statdim = (String)this.paramMap.get("filter_statdim");
        if ("company".equals(statdim)) {
            Collections.swap(columns, 2, 0);
            Collections.swap(columns, 2, 1);
        }
        return super.getColumns(columns);
    }

    public DataSet query(ReportQueryParam param, Object info) throws Throwable {
        this.paramMap = this.transQueryParam(param);
        this.paramMap.putAll(param.getCustomParam());
        QFilter[] qFilters = this.buildFilter(this.paramMap);
        DataSet interestDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_currentintbill", (String)SELECT_FIELDS, (QFilter[])qFilters, null);
        DataSet dateDataSet = interestDataSet.groupBy(new String[]{"inneracctid", "inttype", "currency"}).min("startdate").max("enddate").finish();
        DataSet totalDataGruopSet = interestDataSet.groupBy(new String[]{"settlecenterid", "settlecenter", "account", "inneracctid", "intobjectid", "intobject", "currency", "inttype", "company"}).sum("instprincipal").sum("instamount").finish();
        DataSet normalDataSet = totalDataGruopSet.where("inttype='normal'");
        DataSet normalDataSetCopy = normalDataSet.updateField("inttype", "'overdue'").updateField("instprincipal", "0").updateField("instamount", "0");
        DataSet overdueDataSet = totalDataGruopSet.where("inttype='overdue'");
        DataSet overdueDataSetCopy = overdueDataSet.updateField("inttype", "'normal'").updateField("instprincipal", "0").updateField("instamount", "0");
        DataSet allResult = totalDataGruopSet.union(new DataSet[]{normalDataSetCopy, overdueDataSetCopy});
        DataSet allResultGruop = allResult.groupBy(new String[]{"settlecenterid", "settlecenter", "account", "inneracctid", "intobjectid", "intobject", "currency", "inttype", "company"}).sum("instprincipal").sum("instamount").finish().addField("0", "sumlevel").updateField("instprincipal", "case when inttype='overdue' then instprincipal*-1 else instprincipal end").updateField("instamount", "case when inttype='overdue' and instamount >0 then instamount*-1 else instamount end");
        allResultGruop = allResultGruop.leftJoin(dateDataSet).on("inneracctid", "inneracctid").on("inttype", "inttype").on("currency", "currency").select(allResultGruop.getRowMeta().getFieldNames(), new String[]{"startdate", "enddate"}).finish().orderBy(new String[]{"inneracctid", "inttype", "currency"}).addField("DATEDIF(startdate,enddate,D)+1", "instdays");
        DataSet afterExangedDs = this.getExChangeDs(allResultGruop, param);
        DataSet exchangedDs = allResultGruop.leftJoin(afterExangedDs).on("currency", "currency").select(allResultGruop.getRowMeta().getFieldNames(), new String[]{"tarcurrency", "rate"}).finish();
        DataSet addResult = exchangedDs.addField("instamount*rate", "instamountconvert").addField("instprincipal*rate", "instprincipalconvert");
        DataSet result = this.getResultDataSet(addResult);
        String unit = (String)this.paramMap.get("filter_currencyunit");
        result = ReportHelper.changeUnit(result, unit, Arrays.asList("instprincipal", "instprincipalconvert", "instamount", "instamountconvert"));
        return result;
    }

    private DataSet getResultDataSet(DataSet interestDataSet) {
        String statdim = (String)this.paramMap.get("filter_statdim");
        ArrayList<String> groupFields = new ArrayList<String>(2);
        groupFields.add("tarcurrency");
        String orderByField = "";
        String allSumField = "";
        switch (statdim) {
            case "settlecenter": {
                groupFields.add("settlecenter");
                orderByField = "settlecenter";
                allSumField = "settlecenter";
                break;
            }
            case "company": {
                groupFields.add("company");
                orderByField = "company";
                allSumField = "company";
            }
        }
        DataSet smallCalDs = this.addSubTotalDataSet(interestDataSet, groupFields, Arrays.asList("instprincipalconvert", "instamountconvert"), "intobject");
        DataSet resultDs = interestDataSet.union(smallCalDs).orderBy(new String[]{orderByField});
        DataSet allCalDs = this.addAllTotalDataSet(resultDs, Arrays.asList("instprincipalconvert", "instamountconvert"), Collections.singletonList("tarcurrency"), allSumField);
        resultDs = resultDs.union(allCalDs);
        if (resultDs == null) {
            RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        }
        return resultDs;
    }

    private QFilter[] buildFilter(Map<String, Object> paramMap) {
        DynamicObject intobject = (DynamicObject)paramMap.get("filter_intobject");
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date endDate = (Date)paramMap.get("filter_enddate");
        QFilter qFilter = new QFilter("settlecenter", "!=", (Object)0);
        qFilter.and("intobject", "!=", (Object)0);
        qFilter.and("inneracct", "!=", (Object)0);
        qFilter.and("inneracct.number", "!=", (Object)"");
        qFilter.and("settlecenter", "in", paramMap.get("settlecenterIds"));
        qFilter.and("inneracct.company.id", "in", paramMap.get("orgids"));
        if (EmptyUtil.isNoEmpty((DynamicObject)intobject)) {
            qFilter.and("intobject", "=", intobject.getPkValue());
        }
        qFilter.and("biztype", "=", (Object)"currentint");
        qFilter.and(new QFilter("interestday", ">=", (Object)startDate));
        qFilter.and(new QFilter("interestday", "<=", (Object)endDate));
        qFilter.and(new QFilter("entry.inttype", "in", Arrays.asList("normal", "overdue")));
        return qFilter.toArray();
    }

    private DataSet getExChangeDs(DataSet dataSet, ReportQueryParam param) {
        Long tarCurrencyId = (Long)this.paramMap.get("filter_statcurrency");
        Long exChangetabelid = (Long)this.paramMap.get("exchageTableId");
        String org = (String)this.paramMap.get("org");
        DataSet currencyDataSet = dataSet.copy().groupBy(new String[]{"currency"}).finish();
        return ReportHelper.getExChangeDataSet(currencyDataSet, exChangetabelid, tarCurrencyId, Long.valueOf(org));
    }
}

