/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubsidiaryLedgerTreeDataPlugin
extends AbstractReportTreeDataPlugin {
    private static Log logger = LogFactory.getLog(SubsidiaryLedgerTreeDataPlugin.class);

    private DynamicObjectCollection queryAccts(ReportQueryParam param) {
        DynamicObjectCollection filterAccts;
        List orgIds;
        FilterInfo filterInfo = param.getFilter();
        QFilter acctQF = new QFilter("inneracct", "!=", (Object)0);
        if (this.isSettleCenterSubsidiaryLedger(param)) {
            DynamicObject settleCenter = filterInfo.getDynamicObject("filter_settlecenter");
            Long finOrgId = settleCenter.getLong("id");
            acctQF.and(new QFilter("bank", "=", (Object)finOrgId));
        }
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("filter_org");
        Boolean isIncludeClose = filterInfo.getBoolean("filter_isincludeclose");
        DynamicObject ccy = filterInfo.getDynamicObject("filter_currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) && EmptyUtil.isNoEmpty(orgIds = orgs.stream().map(v -> v.getPkValue()).collect(Collectors.toList()))) {
            acctQF.and(new QFilter("company", "in", orgIds));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(filterAccts = filterInfo.getDynamicObjectCollection("filter_inneraccount")))) {
            List acctIds = filterAccts.stream().map(v -> v.getPkValue()).collect(Collectors.toList());
            acctQF.and(new QFilter("id", "in", acctIds));
        }
        if (!isIncludeClose.booleanValue()) {
            acctQF.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
        acctQF.and(new QFilter("currency.fbasedataid.id", "=", ccy.getPkValue()));
        DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, company.id, bankaccountnumber, name, currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname, acctstatus", (QFilter[])acctQF.toArray());
        return accts;
    }

    private boolean isSettleCenterSubsidiaryLedger(ReportQueryParam param) {
        String appId = (String)param.getCustomParam().get("appid");
        return TmcAppEnum.IFM.getValue().equals(appId);
    }

    public List<TreeNode> query(ReportQueryParam param, String s) throws Throwable {
        DynamicObjectCollection accts = this.queryAccts(param);
        HashSet<Long> orgIds = new HashSet<Long>();
        HashMap<Long, List<DynamicObject>> orgToAccts = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject acct : accts) {
            Long orgId = acct.getLong("company.id");
            orgIds.add(orgId);
            ArrayList<DynamicObject> orgAccts = (ArrayList<DynamicObject>)orgToAccts.get(orgId);
            if (orgAccts == null) {
                orgAccts = new ArrayList<DynamicObject>(10);
                orgToAccts.put(orgId, orgAccts);
            }
            orgAccts.add(acct);
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(20);
        if (this.buildSingleAcct(param, accts, treeNodes)) {
            return treeNodes;
        }
        this.buildOrgTree(param, orgIds, treeNodes);
        for (Long orgId : orgIds) {
            treeNodes.addAll(this.buildAcctNodes(orgId, orgToAccts));
        }
        if (treeNodes.isEmpty()) {
            treeNodes.add(new TreeNode("", "0", ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (String)"SubsidiaryLedgerTreeDataPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0])));
        }
        return treeNodes;
    }

    private boolean buildSingleAcct(ReportQueryParam param, DynamicObjectCollection accts, List<TreeNode> treeNodes) {
        FilterInfo filterInfo = param.getFilter();
        DynamicObjectCollection filterAccts = filterInfo.getDynamicObjectCollection("filter_inneraccount");
        List fitlerAcctIds = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterAccts) && (fitlerAcctIds = filterAccts.stream().map(v -> v.getPkValue()).collect(Collectors.toList())).size() == 1 && accts.size() == 1) {
            for (DynamicObject acct : accts) {
                TreeNode acctNode = new TreeNode();
                acctNode.setId(acct.getString("id") + "-" + acct.getLong("company.id"));
                acctNode.setText(acct.getString("bankaccountnumber") + " " + acct.getString("currencyname"));
                treeNodes.add(acctNode);
            }
            return true;
        }
        return false;
    }

    private void buildOrgTree(ReportQueryParam param, Set<Long> orgIds, List<TreeNode> treeNodes) {
        if (this.isSettleCenterSubsidiaryLedger(param)) {
            QFilter orgViewQFilter = new QFilter("view.id", "=", (Object)8);
            QFilter orgIdQFilter = new QFilter("org.id", "in", orgIds);
            Map org_structure = TmcDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])orgIdQFilter.and(orgViewQFilter).toArray());
            HashSet<String> orgNumberSet = new HashSet<String>();
            Set orgLongNumberSet = org_structure.values().stream().map(v -> v.getString("longnumber")).collect(Collectors.toSet());
            for (String longNumber : orgLongNumberSet) {
                orgNumberSet.addAll(Arrays.asList(longNumber.split("!")));
            }
            QFilter orgNumQFilter = new QFilter("org.number", "in", orgNumberSet);
            org_structure = TmcDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])orgNumQFilter.and(orgViewQFilter).toArray());
            for (DynamicObject org : org_structure.values()) {
                TreeNode node = new TreeNode(org.getString("parent.id"), org.getString("org.id"), org.getString("org.name"));
                treeNodes.add(node);
                node.setIsOpened(true);
            }
        } else {
            DynamicObject[] orgs;
            for (DynamicObject org : orgs = TmcDataServiceHelper.load((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)})) {
                TreeNode node = new TreeNode("", org.getString("id"), org.getString("name"));
                treeNodes.add(node);
                node.setIsOpened(true);
            }
        }
    }

    private List<TreeNode> buildAcctNodes(Long orgId, Map<Long, List<DynamicObject>> orgToAccts) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(20);
        List<DynamicObject> orgAccts = orgToAccts.get(orgId);
        if (orgAccts != null && orgAccts.size() > 0) {
            for (DynamicObject acct : orgAccts) {
                TreeNode acctNode = new TreeNode();
                acctNode.setId(acct.getString("id") + "-" + orgId);
                acctNode.setText(acct.getString("bankaccountnumber") + acct.getString("currencyname"));
                acctNode.setParentid(String.valueOf(orgId));
                treeNodes.add(acctNode);
            }
        }
        return treeNodes;
    }
}

