/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.report.helper.ReportHelper;

public class BalanceCompareFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit settleCenter = (MulBasedataEdit)this.getControl("filter_settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit innerAcct = (MulBasedataEdit)this.getControl("filter_inneracct");
        innerAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field = evt.getProperty().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List f7Filter = showParameter.getListFilterParameter().getQFilters();
        switch (field) {
            case "filter_settlecenter": {
                this.setSettleCenterF7(f7Filter, currUserId, appId);
                break;
            }
            case "filter_inneracct": {
                this.setInnerAcctF7(showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "filter_settlecenter": 
            case "filter_company": 
            case "filter_currency": 
            case "filter_acctuseage": 
            case "filter_includeclose": {
                this.getModel().setValue("filter_inneracct", null);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getModel().setValue("filter_settlecenter", (Object)ReportHelper.getFinOrgDefaultValue(appId, this.getModel().getDataEntityType().getName()));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection settleCenterCols = filter.getDynamicObjectCollection("filter_settlecenter");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)settleCenterCols)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceCompareFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return false;
        }
        Date toDate = filter.getDate("filter_date");
        if (EmptyUtil.isEmpty((Object)toDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceCompareFormPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private void setInnerAcctF7Filter(List<QFilter> f7Filter, String field, String filterColumn) {
        DynamicObjectCollection filterCols = (DynamicObjectCollection)this.getModel().getValue(filterColumn);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCols)) {
            List ids = filterCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getLong("id")).collect(Collectors.toList());
            f7Filter.add(new QFilter(field, "in", ids));
        }
    }

    private void setInnerAcctF7(ListShowParameter showParameter) {
        List f7Filter = showParameter.getListFilterParameter().getQFilters();
        this.setInnerAcctF7Filter(f7Filter, "bank", "filter_settlecenter");
        this.setInnerAcctF7Filter(f7Filter, "company", "filter_company");
        this.setInnerAcctF7Filter(f7Filter, "currency.fbasedataid", "filter_currency");
        this.setInnerAcctF7Filter(f7Filter, "acctproperty", "filter_acctuseage");
        boolean isInclude = (Boolean)this.getModel().getValue("filter_includeclose");
        if (!isInclude) {
            f7Filter.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        }
        showParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"SubsidiaryLedgerListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]));
    }

    private void setSettleCenterF7(List<QFilter> f7Filter, long currUserId, String appId) {
        List<Long> orgIds = ReportHelper.getAuthOrgIds(currUserId, appId, this.getModel().getDataEntityType().getName());
        f7Filter.add(new QFilter("org", "in", orgIds));
        List<Object> finOrgTypeIds = ReportHelper.getFinOrgIds();
        f7Filter.add(new QFilter("finorgtype", "in", finOrgTypeIds));
    }
}

