/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.report.helper.ReportHelper;

public class InterestDetailFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object sdate = filterInfo.getValue("filter_startdate");
            if (sdate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u606f\u5f00\u59cb\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InterestDetailFormListPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object edate = filterInfo.getValue("filter_enddate");
            if (edate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u606f\u7ed3\u675f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InterestDetailFormListPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (((Date)sdate).getTime() >= ((Date)edate).getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u606f\u5f00\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u7ed3\u606f\u7ed3\u675f\u65e5\u3002", (String)"InterestDetailFormListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            long currUserId = RequestContext.get().getCurrUserId();
            List<Long> authOrgIds = ReportHelper.getAuthOrgIds(currUserId, appId, this.getModel().getDataEntityType().getName());
            String orgRootId = String.valueOf(RequestContext.get().getOrgId());
            queryParam.getFilter().addFilterItem("org", (Object)orgRootId);
            DynamicObjectCollection orgids = filterInfo.getDynamicObjectCollection("filter_company");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgids)) {
                List allOrgIds = orgids.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                queryParam.getFilter().addFilterItem("orgids", allOrgIds);
            } else {
                queryParam.getFilter().addFilterItem("orgids", authOrgIds);
            }
            List settlecenterIds = null;
            DynamicObjectCollection settlecenter = filterInfo.getDynamicObjectCollection("filter_settlecenter");
            settlecenterIds = EmptyUtil.isNoEmpty((DynamicObjectCollection)settlecenter) ? settlecenter.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()) : QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{new QFilter("org", "in", authOrgIds)}, null, (int)-1);
            queryParam.getFilter().addFilterItem("settlecenterIds", settlecenterIds);
            Long exchageTableId = TmcBusinessBaseHelper.getExchageTableId((Long)Long.parseLong(orgRootId == null ? "0" : orgRootId));
            queryParam.getFilter().addFilterItem("exchageTableId", (Object)exchageTableId);
            DynamicObject statcurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
            if (EmptyUtil.isEmpty((DynamicObject)statcurrency)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"InterestDetailFormListPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[0]));
                return false;
            }
            queryParam.getCustomParam().put("filter_statcurrency", statcurrency.getPkValue());
            queryParam.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
            queryParam.getCustomParam().put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        }
        return super.verifyQuery(queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        Date startdate = DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1);
        this.getModel().setValue("filter_startdate", (Object)startdate);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("filter_settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("filter_company");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intobject = (BasedataEdit)this.getControl("filter_intobject");
        intobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "filter_intobject": {
                this.intobjectF7(evt);
                break;
            }
            case "filter_settlecenter": {
                this.settlecenterF7(evt);
                break;
            }
            case "filter_company": {
                this.companyF7(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "filter_settlecenter": {
                this.getModel().setValue("filter_intobject", null);
                break;
            }
            case "filter_statdim": 
            case "filter_statcurrency": 
            case "filter_currencyunit": {
                this.autoSearch();
            }
        }
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void intobjectF7(BeforeF7SelectEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        List<Long> authOrgIds = ReportHelper.getAuthOrgIds(currUserId, appId, this.getModel().getDataEntityType().getName());
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObjectCollection settleCenter = (DynamicObjectCollection)this.getModel().getValue("filter_settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)settleCenter)) {
            List settleCenterIds = settleCenter.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            qf.and(new QFilter("settlecenter", "in", settleCenterIds));
        } else {
            qf.and(new QFilter("settlecenter.org.id", "in", authOrgIds));
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_company");
        List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(orgIds)) {
            qf.and(new QFilter("org", "in", orgIds));
        } else {
            qf.and(new QFilter("org", "in", authOrgIds));
        }
        qFilters.add(qf);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(index);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("inneracct.number", "=", (Object)rowData.getString("account")));
        qFilters.add(new QFilter("interestday", ">=", this.getModel().getValue("filter_startdate")));
        qFilters.add(new QFilter("interestday", "<=", this.getModel().getValue("filter_enddate")));
        qFilters.add(new QFilter("currency", "=", rowData.getDynamicObject("currency").getPkValue()));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setIsolationOrg(false);
        showParameter.setBillFormId("ifm_currentintbill");
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("isquerydefault", (Object)"no");
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void settlecenterF7(BeforeF7SelectEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        List<Long> authOrgIds = ReportHelper.getAuthOrgIds(currUserId, appId, this.getModel().getDataEntityType().getName());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("org.id", "in", authOrgIds));
    }

    private void companyF7(BeforeF7SelectEvent evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        List<Long> authOrgIds = ReportHelper.getAuthOrgIds(currUserId, appId, this.getModel().getDataEntityType().getName());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", authOrgIds));
    }
}

