/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanContractBillListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam param) {
        if (param.getFilter().getFilterItem("settlecenter") != null && param.getFilter().getFilterItem("settlecenter").getValue() == null) {
            Set<Long> idSet = this.getAuthorizedBankCenterIds();
            if (idSet.size() <= 0) {
                throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u67e5\u8be2\u6743\u9650\u7684\u7ed3\u7b97\u4e2d\u5fc3", (String)"LoanContractBillListPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0])});
            }
            param.getFilter().getFilterItem("settlecenter").setValue(idSet);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Long id = (Long)evt.getRowData().get("id");
        if ("contractbillno".equals(evt.getFieldName()) && EmptyUtil.isNoEmpty((Long)id)) {
            this.showLoanContractBillForm(id);
        }
    }

    private void showLoanContractBillForm(Long id) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId((Object)id);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("ifm_loancontractbill");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        }
        return Collections.emptySet();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("settlecenter".equals(evt.getProperty().getName())) {
            QFilter filter = new QFilter("id", "in", this.getAuthorizedBankCenterIds());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }
}

